/*
 * Decompiled with CFR 0.152.
 */
package norsys.netica;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import norsys.netica.Environ;
import norsys.netica.NETICA;
import norsys.netica.NeticaException;
import norsys.netica.Util;

public class Streamer {
    Environ parentEnv;
    long streamPtr;
    long inStreamStringOpaqueBufferPtr = 0L;
    OutputStream outputStream = null;
    String streamerFileName = null;

    public Streamer(String string) throws NeticaException {
        this(string, Environ.getDefaultEnviron());
    }

    public Streamer(String string, Environ environ) throws NeticaException {
        this.parentEnv = environ;
        this.streamPtr = NETICA.NewFileStream_ns(string, this.parentEnv.envPtr, null);
        this.parentEnv.testForError();
        this.streamerFileName = string;
        if (this.streamPtr == 0L) {
            throw new NeticaException(6004, "Streamer: Construction failed.");
        }
        Util.log("NETICA: created Streamer for file: " + string);
    }

    public Streamer(InputStream inputStream, String string, Environ environ) throws NeticaException {
        byte[] byArray;
        this.parentEnv = environ;
        int n = 0;
        byte[] byArray2 = new byte[10000];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(10000);
        try {
            while ((n = inputStream.read(byArray2, 0, 10000)) != -1) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            inputStream.close();
            byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            throw new NeticaException("Streamer(InputStream, String, Environ): IOException reading InputStream");
        }
        if (environ == null) {
            System.err.println(" env is NULL!");
        }
        this.streamPtr = NETICA.NewMemoryStream_ns(string, environ.envPtr, null);
        environ.testForError();
        this.inStreamStringOpaqueBufferPtr = NETICA.SetStreamContents_ns(this.streamPtr, byArray, true);
        environ.testForError();
    }

    public Streamer(OutputStream outputStream, String string, Environ environ) throws NeticaException {
        this.parentEnv = environ;
        this.outputStream = outputStream;
        this.streamPtr = NETICA.NewMemoryStream_ns(string, environ.envPtr, null);
        environ.testForError();
    }

    public void finalize() throws NeticaException {
        if (this.streamPtr == 0L) {
            return;
        }
        if (this.outputStream != null) {
            this.flush();
            try {
                this.outputStream.close();
            }
            catch (IOException iOException) {
                throw new NeticaException("Streamer.finalize(): IOException closing outputStream");
            }
        }
        NETICA.DeleteStream_ns(this.streamPtr, this.inStreamStringOpaqueBufferPtr);
        this.parentEnv.testForError();
        this.streamPtr = 0L;
    }

    public void flush() throws NeticaException {
        if (this.streamPtr == 0L) {
            return;
        }
        if (this.outputStream != null) {
            try {
                if (this.outputStream instanceof ByteArrayOutputStream) {
                    byte[] byArray = NETICA.GetStreamContents_ns(this.streamPtr);
                    ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)this.outputStream;
                    this.outputStream.write(byArray, 0, byArray.length);
                }
                this.outputStream.flush();
            }
            catch (IOException iOException) {
                throw new NeticaException("Streamer.flush(): IOException flushing stream.");
            }
        }
    }

    public Environ getEnviron() throws NeticaException {
        return this.parentEnv;
    }

    public String getFileName() throws NeticaException {
        return this.streamerFileName;
    }

    public void setPassword(String string) throws NeticaException {
        if (this.streamPtr == 0L) {
            return;
        }
        NETICA.SetStreamPassword_ns(this.streamPtr, string);
        this.parentEnv.testForError();
    }

    public void close() throws NeticaException {
        this.finalize();
    }
}

