/*
 * Decompiled with CFR 0.152.
 */
package norsys.netica;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import norsys.netica.Environ;
import norsys.netica.General;
import norsys.netica.NETICA;
import norsys.netica.NeticaException;
import norsys.netica.State;

public class User {
    private int parentType;
    private General parent;
    private Object referenceObj;

    User(General general) throws NeticaException {
        this.parent = general;
        this.parentType = general.parentType;
        general.assertIsViable();
    }

    private long getPtr() throws NeticaException {
        return this.parent.getPtr();
    }

    private int getStateIndex() {
        return ((State)this.parent).stateIndex;
    }

    public byte[] getBytes(String string) throws NeticaException {
        int[] nArray = new int[1];
        byte[] byArray = null;
        switch (this.parentType) {
            case 1: {
                byArray = NETICA.GetNetUserField_bn(this.getPtr(), string, nArray, 0);
                break;
            }
            case 2: {
                byArray = NETICA.GetNodeUserField_bn(this.getPtr(), string, nArray, 0);
                break;
            }
            case 3: {
                throw new NeticaException("unsupported User feature for states");
            }
        }
        this.parent.parentEnv.testForError();
        if (nArray[0] == -1) {
            return null;
        }
        return byArray;
    }

    public double getNumber(String string) throws NeticaException, IOException {
        String string2 = this.getString(string);
        if (string2 == null) {
            return Environ.UNDEF_DBL;
        }
        return Double.parseDouble(string2);
    }

    public String getNthFieldName(int n) throws NeticaException {
        String[] stringArray = new String[1];
        int[] nArray = new int[1];
        switch (this.parentType) {
            case 1: {
                NETICA.GetNetNthUserField_bn(this.getPtr(), n, stringArray, null, nArray, 0);
                break;
            }
            case 2: {
                NETICA.GetNodeNthUserField_bn(this.getPtr(), n, stringArray, null, nArray, 0);
                break;
            }
            case 3: {
                throw new NeticaException("unsupported User feature for states");
            }
        }
        this.parent.parentEnv.testForError();
        if (nArray[0] == -1 || stringArray == null || stringArray[0] == null) {
            return null;
        }
        return stringArray[0];
    }

    public Object getObject(String string) throws NeticaException {
        byte[] byArray = this.getBytes(string);
        if (byArray == null) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            return objectInputStream.readObject();
        }
        catch (IOException iOException) {
            try {
                return new String(byArray, "UTF-8");
            }
            catch (Exception exception) {
                throw new NeticaException("User.getField: IOException reading ObjectInputStream");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NeticaException("User.getField: ClassNotFoundException reading ObjectInputStream");
        }
    }

    public Object getReference() throws NeticaException {
        return this.referenceObj;
    }

    public String getString(String string) throws NeticaException {
        byte[] byArray = this.getBytes(string);
        if (byArray == null) {
            return null;
        }
        try {
            return new String(byArray, "UTF-8");
        }
        catch (Exception exception) {
            throw new NeticaException("Internal systems error in getString(); please e-mail this message to netica-j@norsys.com. Thank you");
        }
    }

    public void removeField(String string) throws NeticaException {
        this.setBytes(string, null);
    }

    public void setBytes(String string, byte[] byArray) throws NeticaException {
        if (this.parentType == 3) {
            throw new NeticaException("unsupported User feature for States");
        }
        int n = 0;
        if (byArray != null) {
            n = byArray.length;
        }
        switch (this.parentType) {
            case 1: {
                NETICA.SetNetUserField_bn(this.getPtr(), string, byArray, n, 0);
                break;
            }
            case 2: {
                NETICA.SetNodeUserField_bn(this.getPtr(), string, byArray, n, 0);
            }
        }
        this.parent.parentEnv.testForError();
    }

    public void setNumber(String string, double d) throws NeticaException, IOException {
        this.setString(string, "" + d);
    }

    public void setObject(String string, Serializable serializable) throws NeticaException {
        if (serializable == null) {
            this.setBytes(string, null);
        } else {
            Object object;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                object = new ObjectOutputStream(byteArrayOutputStream);
                ((ObjectOutputStream)object).writeObject(serializable);
            }
            catch (IOException iOException) {
                throw new NeticaException("User.setObject: IOException serializing fieldValue.");
            }
            object = byteArrayOutputStream.toByteArray();
            this.setBytes(string, (byte[])object);
        }
    }

    public void setReference(Object object) throws NeticaException {
        this.referenceObj = object;
    }

    public void setString(String string, String string2) throws NeticaException {
        if (string2 == null) {
            this.setBytes(string, null);
        } else {
            byte[] byArray = null;
            try {
                byArray = string2.getBytes("UTF-8");
            }
            catch (Exception exception) {
                throw new NeticaException("Internal systems error in setString(); please e-mail this message to netica-j@norsys.com. Thank you");
            }
            this.setBytes(string, byArray);
        }
    }
}

