/*
 * Decompiled with CFR 0.152.
 */
package norsys.neticaEx;

import norsys.netica.Net;
import norsys.netica.NeticaException;
import norsys.netica.Node;
import norsys.netica.NodeList;
import norsys.neticaEx.NodeListEx;

public class NodeEx
extends Node {
    public NodeEx(String string, int n, Net net) throws NeticaException {
        super(string, n, net);
    }

    public NodeEx(String string, String string2, Net net) throws NeticaException {
        super(string, string2, net);
    }

    public NodeEx() throws NeticaException {
    }

    public static void absorb(Node node) throws NeticaException {
        Net net = node.getNet();
        NodeList nodeList = new NodeList(net);
        nodeList.add(node);
        net.absorb(nodeList);
    }

    public Node duplicate(Net net) throws NeticaException {
        NodeList nodeList = new NodeList(this.getNet());
        nodeList.add(this);
        NodeList nodeList2 = net.copyNodes(nodeList);
        return (Node)nodeList2.get(0);
    }

    public Node duplicate() throws NeticaException {
        return this.duplicate(this.getNet());
    }

    public void setCPTable(String string, double d, double d2) throws NeticaException {
        float[] fArray = new float[]{(float)d, (float)d2};
        this.setCPTable(string, fArray);
    }

    public void setCPTable(String string, double d, double d2, double d3) throws NeticaException {
        float[] fArray = new float[]{(float)d, (float)d2, (float)d3};
        this.setCPTable(string, fArray);
    }

    public void setCPTable(double d, double d2) throws NeticaException {
        this.setCPTable(null, d, d2);
    }

    public void setCPTable(double d, double d2, double d3) throws NeticaException {
        this.setCPTable(null, d, d2, d3);
    }

    public void setCPTable(String string, String string2, double d, double d2) throws NeticaException {
        float[] fArray = new float[]{(float)d, (float)d2};
        this.setCPTable(string + "," + string2, fArray);
    }

    public float[] getCPTable(int[] nArray) throws NeticaException {
        return this.getCPTable(nArray, null);
    }

    public float[] getCPTable(String string) throws NeticaException {
        return this.getCPTable(string, null);
    }

    public float[] getCPTable() throws NeticaException {
        return this.getCPTable((float[])null);
    }

    public void changeFinding(int n) throws NeticaException {
        int n2 = this.getNet().getAutoUpdate();
        this.getNet().setAutoUpdate(0);
        this.finding().clear();
        this.finding().enterState(n);
        this.getNet().setAutoUpdate(n2);
    }

    public void changeFinding(String string) throws NeticaException {
        this.changeFinding(this.state(string).getIndex());
    }

    public void changeValue(double d) throws NeticaException {
        this.getNet().setAutoUpdate(0);
        this.finding().clear();
        this.finding().enterReal(d);
        this.getNet().setAutoUpdate(256);
    }

    public void enterFindingNot(String string) throws NeticaException {
        this.finding().enterStateNot(this.state(string).getIndex());
    }

    public int getParentIndex(Node node) throws NeticaException {
        NodeList nodeList = this.getParents();
        for (int i = 0; i < nodeList.size(); ++i) {
            Node node2 = (Node)nodeList.get(i);
            if (!node2.equals(node)) continue;
            return i;
        }
        return -1;
    }

    public int getParentIndex(String string) throws NeticaException {
        Node node = this.getNet().getNode(string);
        return this.getParentIndex(node);
    }

    public static void deleteLink(Node node, Node node2) throws NeticaException {
        NodeList nodeList = node2.getParents();
        int n = nodeList.indexOf(node);
        node2.deleteLink(n);
    }

    public void deleteLinks(Node node) throws NeticaException {
        NodeList nodeList = this.getParents();
        for (int i = 0; i < nodeList.size(); ++i) {
            Node node2 = (Node)nodeList.get(i);
            if (!node2.equals(node)) continue;
            this.deleteLink(i);
        }
    }

    public static void deleteLinksEntering(Node node) throws NeticaException {
        NodeList nodeList = node.getParents();
        int n = nodeList.size();
        for (int i = 0; i < n; ++i) {
            node.deleteLink(0);
        }
    }

    public void switchParent(Node node, Node node2) throws NeticaException {
        int n = this.getParentIndex(node);
        this.switchParent(n, node2);
    }

    public String getStateNames() throws NeticaException {
        String[] stringArray = this.getStateNamesArray();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(this.state(i).getName());
        }
        return stringBuffer.toString();
    }

    public String[] getStateNamesArray() throws NeticaException {
        int n = this.getNumStates();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.state(i).getName();
        }
        return stringArray;
    }

    public static void makeProbsUniform(Node node) throws NeticaException {
        int n;
        int n2 = node.getNumStates();
        int n3 = node.getParents().size();
        float[] fArray = new float[n2];
        int[] nArray = new int[n3];
        for (n = 0; n < n2; ++n) {
            fArray[n] = 1.0f / (float)n2;
        }
        for (n = 0; n < n3; ++n) {
            nArray[n] = -5;
        }
        node.setCPTable(nArray, fArray);
    }

    public static void setNodeAllProbs(Node node, float[][] fArray) throws NeticaException {
        NodeList nodeList = node.getParents();
        int[] nArray = new int[nodeList.size()];
        int n = 0;
        do {
            node.setCPTable(nArray, fArray[n++]);
        } while (!NodeListEx.nextStates(nArray, nodeList));
    }

    public static float[][] getNodeAllProbs(Node node, float[][] fArray) throws NeticaException {
        float[] fArray2;
        NodeList nodeList = node.getParents();
        int n = node.getNumStates();
        if (fArray == null) {
            fArray = new float[(int)NodeListEx.sizeCartesianProduct(node.getParents())][n];
        }
        int[] nArray = new int[nodeList.size()];
        int n2 = 0;
        while ((fArray2 = node.getCPTable(nArray, null)) != null) {
            for (int i = 0; i < n; ++i) {
                fArray[n2][i] = fArray2[i];
            }
            if (NodeListEx.nextStates(nArray, nodeList)) break;
            ++n2;
        }
        return fArray;
    }

    public static void setNodeFuncState(Node node, int[] nArray) throws NeticaException {
        NodeList nodeList = node.getParents();
        int[] nArray2 = new int[nodeList.size()];
        int n = 0;
        do {
            node.setStateFuncTable(nArray2, nArray[n++]);
        } while (!NodeListEx.nextStates(nArray2, nodeList));
    }

    public static void setNodeFuncReal(Node node, double[] dArray) throws NeticaException {
        NodeList nodeList = node.getParents();
        int[] nArray = new int[nodeList.size()];
        int n = 0;
        do {
            node.setRealFuncTable(nArray, dArray[n++]);
        } while (!NodeListEx.nextStates(nArray, nodeList));
    }

    public static boolean isLinkDisconnected(int n, Node node) throws NeticaException {
        NodeList nodeList = node.getParents();
        Node node2 = (Node)nodeList.get(n);
        return node2.getKind() == 205;
    }

    public int[] getStateFuncTable(String string, int[] nArray) throws NeticaException {
        return this.getStateFuncTable(this.parentStatesToIndexes(string), nArray);
    }

    public int[] getStateFuncTable(String string) throws NeticaException {
        return this.getStateFuncTable(this.parentStatesToIndexes(string), null);
    }

    public double[] getRealFuncTable(String string, double[] dArray) throws NeticaException {
        return this.getRealFuncTable(this.parentStatesToIndexes(string), dArray);
    }

    public double[] getRealFuncTable(String string) throws NeticaException {
        return this.getRealFuncTable(this.parentStatesToIndexes(string), null);
    }

    public double[] getExperTable(String string, double[] dArray) throws NeticaException {
        return this.getExperTable(this.parentStatesToIndexes(string), dArray);
    }

    public double[] getExperTable(String string) throws NeticaException {
        return this.getExperTable(this.parentStatesToIndexes(string), null);
    }

    public void setStateFuncTable(String string, int n) throws NeticaException {
        this.setStateFuncTable(this.parentStatesToIndexes(string), n);
    }

    public void setRealFuncTable(String string, double d) throws NeticaException {
        this.setRealFuncTable(this.parentStatesToIndexes(string), d);
    }

    public void setExperTable(String string, double d) throws NeticaException {
        this.setExperTable(this.parentStatesToIndexes(string), d);
    }
}

