/*
 * Decompiled with CFR 0.152.
 */
package norsys.netica;

import java.util.Hashtable;
import java.util.StringTokenizer;
import norsys.netica.Environ;
import norsys.netica.General;
import norsys.netica.NETICA;
import norsys.netica.Net;
import norsys.netica.NeticaEvent;
import norsys.netica.NeticaException;
import norsys.netica.NodeList;
import norsys.netica.State;
import norsys.netica.Util;
import norsys.netica.Value;
import norsys.netica.VisualNode;

public class Node
extends General {
    Value finding = null;
    Value belief = null;
    Value calculated = null;
    Value action = null;
    public static final int CONTINUOUS_TYPE = 101;
    public static final int DISCRETE_TYPE = 102;
    public static final int TEXT_TYPE = 103;
    public static final int CONSTANT_NODE = 202;
    public static final int DECISION_NODE = 203;
    public static final int DISCONNECTED_NODE = 205;
    public static final int NATURE_NODE = 201;
    public static final int UTILITY_NODE = 204;
    public static final int EVERY_STATE = -5;
    public static final int IMPOSS_STATE = -4;
    public static final int UNDEF_STATE = -3;
    public static final int LIKELIHOOD_FINDING = -6;
    public static final int NEGATIVE_FINDING = -7;
    public static final int NO_FINDING = -3;
    long nodePtr;
    Net parentNet;
    private Object userData;
    private VisualNode visual;
    private Hashtable listeners = new Hashtable();
    private static String constructorClass = "norsys.netica.Node";
    private static boolean constructorClassHasBeenSet = false;
    private Hashtable states = null;

    public Node(String string, int n, Net net) throws NeticaException {
        long l = NETICA.NewNode_bn(string, n, net.netPtr);
        net.parentEnv.testForError();
        this.hookupToNative(l, net);
    }

    public Node(String string, String string2, Net net) throws NeticaException {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",< \t;:.(){}[]>");
        int n = stringTokenizer.countTokens();
        long l = NETICA.NewNode_bn(string, n, net.netPtr);
        net.parentEnv.testForError();
        this.hookupToNative(l, net);
        this.setStateNames(string2);
    }

    public Node() throws NeticaException {
    }

    void hookupToNative(long l, Net net) throws NeticaException {
        this.parentNet = net;
        this.parentEnv = net.parentEnv;
        this.nodePtr = l;
        NETICA.SetJavaApiNode_bn(l, this);
        if (this.getKind() != 205) {
            this.parentEnv.testForError();
            this.addListener(this);
        }
        this.parentEnv.testForError();
        Util.log("NETICA: created Node: " + this.getName());
    }

    void onDeleteCallback(NeticaEvent neticaEvent) throws NeticaException {
        Util.log("Node.onDeleteCallback() called.\n");
        if (neticaEvent.getObject() != this) {
            if (Util.devel) {
                System.out.println(" *** WARNING *** NETICA_J. Node.onDeleteCallback().  Notified of event on object I'm not listening to:   event.id=" + neticaEvent.getKind() + "    Event was on object" + neticaEvent.getObject());
            }
            return;
        }
        this.removeListener(this);
        Util.log(" *** Node:onDeleteCallback SUCCESS!!");
        this.nodePtr = 0L;
    }

    void assertNodeIsViable() throws NeticaException {
        if (this.parentEnv == null || this.parentEnv.envPtr == 0L) {
            throw new NeticaException(6005, "The Environ associated with this object has been closed and so this object should no longer be used.");
        }
        if (this.nodePtr == 0L) {
            throw new NeticaException(6005, "Native node object no longer exists, so this Node should no longer be used.");
        }
    }

    static Node getNodeFromPtr(long l, Net net) throws NeticaException {
        Node node = NETICA.GetJavaApiNode_bn(l);
        if (node == null) {
            try {
                Class clazz = net.getEnviron().isNodeClassOverridden() ? net.getEnviron().getNodeClass() : (constructorClassHasBeenSet ? Class.forName(Node.getConstructorClass()) : net.getEnviron().getNodeClass());
                node = (Node)clazz.newInstance();
            }
            catch (Exception exception) {
                throw new NeticaException(6000, "Internal error during Node construction.");
            }
            node.hookupToNative(l, net);
        } else if (Util.devel) {
            System.out.println("**** SUCCESSFULLY reusing a Node, YIPPEE!!!");
        }
        return node;
    }

    public Value action() {
        this.action = new Value(this, 2);
        return this.action;
    }

    public int addLink(Node node) throws NeticaException {
        if (node == null) {
            throw new NeticaException("PARENT NODE is NULL!");
        }
        int n = NETICA.AddLink_bn(node.nodePtr, this.nodePtr);
        if (this.parentEnv == null) {
            throw new NeticaException("PARENT ENVIRON is NULL!");
        }
        this.parentEnv.testForError();
        return n;
    }

    public void addToNodeset(String string) throws NeticaException {
        NETICA.AddNodeToNodeset_bn(this.nodePtr, string);
        this.parentEnv.testForError();
    }

    public void addStates(int n, String string, int n2, double d) throws NeticaException {
        NETICA.AddNodeStates_bn(this.nodePtr, n, string, n2, d);
        this.parentEnv.testForError();
    }

    public int calcState() throws NeticaException {
        int n = NETICA.CalcNodeState_bn(this.nodePtr);
        this.parentEnv.testForError();
        return n;
    }

    public double calcValue() throws NeticaException {
        double d = NETICA.CalcNodeValue_bn(this.nodePtr);
        this.parentEnv.testForError();
        return d;
    }

    public void delete() throws NeticaException {
        if (this.nodePtr == 0L) {
            if (Environ.isAndroid) {
                return;
            }
            throw new NeticaException(6005, "Node.delete(): Native node was already deleted.");
        }
        String string = this.getName();
        NETICA.DeleteNode_bn(this.nodePtr);
        this.parentEnv.testForError();
        Util.log("NETICA: deleted Node: " + string);
    }

    public void deleteLink(int n) throws NeticaException {
        NETICA.DeleteLink_bn(n, this.nodePtr);
        this.parentEnv.testForError();
    }

    public void deleteTables() throws NeticaException {
        NETICA.DeleteNodeTables_bn(this.nodePtr);
        this.parentEnv.testForError();
    }

    public void equationToTable(int n, boolean bl, boolean bl2) throws NeticaException {
        NETICA.EquationToTable_bn(this.nodePtr, n, bl, bl2);
        this.parentEnv.testForError();
    }

    public void fadeCPTable(double d) throws NeticaException {
        NETICA.FadeCPTable_bn(this.nodePtr, d);
        this.parentEnv.testForError();
    }

    public void finalize() throws NeticaException {
        if (this.nodePtr != 0L) {
            this.removeListener(this);
        }
    }

    public Value finding() {
        this.finding = new Value(this, 1);
        return this.finding;
    }

    public float getBelief(String string) throws NeticaException {
        int n = this.state(string).getIndex();
        float[] fArray = NETICA.GetNodeBeliefs_bn(this.nodePtr);
        this.parentEnv.testForError();
        return fArray[n];
    }

    public float[] getBeliefs() throws NeticaException {
        float[] fArray = NETICA.GetNodeBeliefs_bn(this.nodePtr);
        this.parentEnv.testForError();
        return fArray;
    }

    public NodeList getChildren() throws NeticaException {
        long l = NETICA.GetNodeChildren_bn(this.nodePtr);
        this.parentEnv.testForError();
        return new NodeList(l, this.parentNet);
    }

    public static String getConstructorClass() {
        return constructorClass;
    }

    public float[] getCPTable(int[] nArray, float[] fArray) throws NeticaException {
        float[] fArray2 = NETICA.GetNodeProbs_bn(this.nodePtr, nArray, fArray);
        this.parentEnv.testForError();
        return fArray2;
    }

    public float[] getCPTable(String string, float[] fArray) throws NeticaException {
        return this.getCPTable(this.parentStatesToIndexes(string), fArray);
    }

    public float[] getCPTable(float[] fArray) throws NeticaException {
        float[] fArray2 = NETICA.GetNodeProbs_bn(this.nodePtr, null, fArray);
        this.parentEnv.testForError();
        return fArray2;
    }

    public String getEquation() throws NeticaException {
        String string = NETICA.GetNodeEquation_bn(this.nodePtr);
        this.parentEnv.testForError();
        return string;
    }

    public float[] getExpectedUtils() throws NeticaException {
        float[] fArray = NETICA.GetNodeExpectedUtils_bn(this.nodePtr);
        this.parentEnv.testForError();
        return fArray;
    }

    public double getExpectedValue(double[] dArray) throws NeticaException {
        double[] dArray2 = new double[1];
        double d = NETICA.GetNodeExpectedValue_bn(this.nodePtr, dArray2, null, null);
        this.parentEnv.testForError();
        if (dArray != null) {
            if (dArray.length > 0) {
                dArray[0] = d;
            }
            if (dArray.length > 1) {
                dArray[1] = dArray2[0];
            }
        }
        return d;
    }

    public double[] getExperTable(int[] nArray, double[] dArray) throws NeticaException {
        if (dArray == null || dArray.length == 0) {
            double[] dArray2 = new double[]{NETICA.GetNodeExperience_bn(this.nodePtr, nArray)};
            this.parentEnv.testForError();
            return dArray2;
        }
        dArray[0] = NETICA.GetNodeExperience_bn(this.nodePtr, nArray);
        this.parentEnv.testForError();
        return dArray;
    }

    public int getInputIndex(String string) throws NeticaException {
        int n = NETICA.InputNamed_bn(string, this.nodePtr);
        this.parentEnv.testForError();
        return n;
    }

    public String getInputName(int n) throws NeticaException {
        String string = NETICA.GetNodeInputName_bn(this.nodePtr, n);
        this.parentEnv.testForError();
        return string;
    }

    public int getKind() throws NeticaException {
        int n = NETICA.GetNodeKind_bn(this.nodePtr);
        this.parentEnv.testForError();
        return n + 200;
    }

    public double[] getLevels() throws NeticaException {
        double[] dArray = NETICA.GetNodeLevels_bn(this.nodePtr);
        this.parentEnv.testForError();
        return dArray;
    }

    public Net getNet() {
        return this.parentNet;
    }

    public int getNumStates() throws NeticaException {
        int n = NETICA.GetNodeNumberStates_bn(this.nodePtr);
        this.parentEnv.testForError();
        return n;
    }

    public NodeList getParents() throws NeticaException {
        long l = NETICA.GetNodeParents_bn(this.nodePtr);
        this.parentEnv.testForError();
        return new NodeList(l, this.parentNet);
    }

    public double[] getRealFuncTable(int[] nArray, double[] dArray) throws NeticaException {
        if (dArray == null || dArray.length == 0) {
            double[] dArray2 = new double[]{NETICA.GetNodeFuncReal_bn(this.nodePtr, nArray)};
            this.parentEnv.testForError();
            return dArray2;
        }
        dArray[0] = NETICA.GetNodeFuncReal_bn(this.nodePtr, nArray);
        this.parentEnv.testForError();
        return dArray;
    }

    public void getRelatedNodes(NodeList nodeList, String string) throws NeticaException {
        long l = nodeList.getNodeListPtr(this.parentNet);
        NETICA.GetRelatedNodes_bn(l, string, this.nodePtr);
        this.parentEnv.testForError();
        NodeList nodeList2 = new NodeList(l, this.parentNet);
        this.parentEnv.testForError();
        nodeList.removeAllElements();
        nodeList.addAll(nodeList2);
    }

    public int[] getStateFuncTable(int[] nArray, int[] nArray2) throws NeticaException {
        if (nArray2 == null || nArray2.length == 0) {
            int[] nArray3 = new int[]{NETICA.GetNodeFuncState_bn(this.nodePtr, nArray)};
            this.parentEnv.testForError();
            return nArray3;
        }
        nArray2[0] = NETICA.GetNodeFuncState_bn(this.nodePtr, nArray);
        this.parentEnv.testForError();
        return nArray2;
    }

    public int getType() throws NeticaException {
        int n = NETICA.GetNodeType_bn(this.nodePtr);
        this.parentEnv.testForError();
        return n + 100;
    }

    public boolean hasTable(boolean[] blArray) throws NeticaException {
        if (blArray != null && blArray.length < 1) {
            throw new NeticaException("Parameter complete[] to Node.hasTable() is null or of zero length.");
        }
        boolean bl = NETICA.HasNodeTable_bn(this.nodePtr, blArray);
        this.parentEnv.testForError();
        return bl;
    }

    public boolean isBeliefUpdated() throws NeticaException {
        boolean bl = NETICA.IsBeliefUpdated_bn(this.nodePtr);
        this.parentEnv.testForError();
        return bl;
    }

    public boolean isDeterministic() throws NeticaException {
        boolean bl = NETICA.IsNodeDeterministic_bn(this.nodePtr);
        this.parentEnv.testForError();
        return bl;
    }

    public boolean isInNodeset(String string) throws NeticaException {
        boolean bl = NETICA.IsNodeInNodeset_bn(this.nodePtr, string);
        this.parentEnv.testForError();
        return bl;
    }

    public boolean isRelated(String string, Node node) throws NeticaException {
        boolean bl = NETICA.IsNodeRelated_bn(this.getNodePtr(), string, node.getNodePtr());
        this.parentEnv.testForError();
        return bl;
    }

    public int[] parentStatesToIndexes(String string) throws NeticaException {
        return Node.stringToStates(string, this.getParents());
    }

    public void removeFromNodeset(String string) throws NeticaException {
        NETICA.RemoveNodeFromNodeset_bn(this.nodePtr, string);
        this.parentEnv.testForError();
    }

    public void reorderStates(int[] nArray) throws NeticaException {
        int n = this.getNumStates();
        if (nArray.length != n) {
            throw new NeticaException("The Number of states supplied in the reordered states array (" + nArray.length + ") does not match the number of states for this node (" + n + ").");
        }
        NETICA.ReorderNodeStates_bn(this.nodePtr, nArray);
        this.parentEnv.testForError();
        this.states = null;
    }

    public void reverseLink(Node node) throws NeticaException {
        NETICA.ReverseLink_bn(node.nodePtr, this.nodePtr);
        this.parentEnv.testForError();
    }

    public static void setConstructorClass(String string) throws NeticaException {
        Class<?> clazz;
        Class<?> clazz2;
        Object var1_1 = null;
        try {
            clazz2 = Class.forName(string);
            clazz = Class.forName("norsys.netica.Node");
        }
        catch (Exception exception) {
            throw new NeticaException(6001, "The class " + string + " could not be found on the classpath.");
        }
        try {
            var1_1 = clazz2.newInstance();
        }
        catch (Exception exception) {
            throw new NeticaException(6002, "The class " + string + " does not have a default construtor.");
        }
        if (!clazz.isAssignableFrom(clazz2)) {
            throw new NeticaException(6002, string + " is not an extension of norsys.netica.Node");
        }
        constructorClass = string;
        constructorClassHasBeenSet = true;
    }

    public void setCPTable(int[] nArray, float[] fArray) throws NeticaException {
        NETICA.SetNodeProbs_bn(this.nodePtr, nArray, fArray);
        this.parentEnv.testForError();
    }

    public void setCPTable(String string, float[] fArray) throws NeticaException {
        this.setCPTable(this.parentStatesToIndexes(string), fArray);
    }

    public void setCPTable(float[] fArray) throws NeticaException {
        NETICA.SetNodeProbs_bn(this.nodePtr, null, fArray);
        this.parentEnv.testForError();
    }

    public void setEquation(String string) throws NeticaException {
        NETICA.SetNodeEquation_bn(this.nodePtr, string);
        this.parentEnv.testForError();
    }

    public void setExperTable(int[] nArray, double d) throws NeticaException {
        int n = this.getNumParents();
        if (nArray.length != this.getNumParents()) {
            throw new NeticaException("The parentStates array is of length " + nArray.length + ", but the number of parents for this node is " + n + "; the two must be identical.");
        }
        NETICA.SetNodeExperience_bn(this.nodePtr, nArray, d);
        this.parentEnv.testForError();
    }

    private int getNumParents() throws NeticaException {
        NodeList nodeList = this.getParents();
        return nodeList.size();
    }

    public void setExperTable(double d) throws NeticaException {
        int n = this.getNumParents();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = -5;
        }
        NETICA.SetNodeExperience_bn(this.nodePtr, nArray, d);
        this.parentEnv.testForError();
    }

    public void setInputName(int n, String string) throws NeticaException {
        NETICA.SetNodeInputName_bn(this.nodePtr, n, string);
        this.parentEnv.testForError();
    }

    public void setKind(int n) throws NeticaException {
        if (n < 201 || n > 205) {
            throw new NeticaException("Invalid kind; must be one of: NATURE_NODE, CONSTANT_NODE, DECISION_NODE, UTILITY_NODE, or DISCONNECTED_NODE.");
        }
        NETICA.SetNodeKind_bn(this.nodePtr, n - 200);
        this.parentEnv.testForError();
    }

    public void setLevels(double[] dArray) throws NeticaException {
        if (dArray == null) {
            NETICA.SetNodeLevels_bn(this.nodePtr, 0, null);
        } else if (this.getType() == 102) {
            NETICA.SetNodeLevels_bn(this.nodePtr, this.getNumStates(), dArray);
        } else {
            NETICA.SetNodeLevels_bn(this.nodePtr, dArray.length - 1, dArray);
        }
        this.parentEnv.testForError();
    }

    public void setRealFuncTable(int[] nArray, double d) throws NeticaException {
        NETICA.SetNodeFuncReal_bn(this.nodePtr, nArray, d);
        this.parentEnv.testForError();
    }

    public void setStateFuncTable(int[] nArray, int n) throws NeticaException {
        NETICA.SetNodeFuncState_bn(this.nodePtr, nArray, n);
        this.parentEnv.testForError();
    }

    public void setStateNames(String string) throws NeticaException {
        NETICA.SetNodeStateNames_bn(this.nodePtr, string);
        this.parentEnv.testForError();
    }

    public State state(int n) throws NeticaException {
        Integer n2;
        Object v;
        int n3 = this.getNumStates();
        if (n3 <= 0) {
            throw new NeticaException("This node does not have discrete states");
        }
        if (n < 0 || n >= n3) {
            throw new NeticaException("stateIndex is out of range 0.." + (n3 - 1));
        }
        if (this.states == null) {
            this.states = new Hashtable();
        }
        if ((v = this.states.get(n2 = new Integer(n))) != null) {
            return (State)v;
        }
        State state = new State(this, n);
        this.states.put(n2, state);
        return state;
    }

    public State state(String string) throws NeticaException {
        int n = NETICA.StateNamed_bn(string, this.nodePtr);
        this.parentEnv.testForError();
        if (n == -3) {
            if (string != null && string.length() > 1 && string.charAt(0) == 's') {
                try {
                    int n2 = Integer.parseInt(string.substring(1));
                    return this.state(n2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new NeticaException("No state of this node has the name '" + string + "'");
        }
        return this.state(n);
    }

    public void switchParent(int n, Node node) throws NeticaException {
        if (node == null) {
            NETICA.SwitchNodeParent_bn(n, this.nodePtr, 0L);
        } else {
            NETICA.SwitchNodeParent_bn(n, this.nodePtr, node.nodePtr);
        }
        this.parentEnv.testForError();
    }

    public VisualNode visual() throws NeticaException {
        if (this.visual == null) {
            this.visual = new VisualNode(this);
        }
        return this.visual;
    }

    public void setInputDelay(int n, int n2, String string) throws NeticaException {
        NETICA.SetNodeInputDelay_bn(this.nodePtr, n, n2, string);
        this.parentEnv.testForError();
    }

    public void setPersistance(int n, String string) throws NeticaException {
        NETICA.SetNodePersistance_bn(this.nodePtr, n, string);
        this.parentEnv.testForError();
    }

    public void enterFinding(int n) throws NeticaException {
        this.finding().enterState(n);
    }

    public void enterFinding(String string) throws NeticaException {
        this.finding().enterState(string);
    }

    public void enterFindingNot(int n) throws NeticaException {
        this.finding().enterStateNot(n);
    }

    public void enterValue(double d) throws NeticaException {
        this.finding().enterReal(d);
    }

    public void enterLikelihood(float[] fArray) throws NeticaException {
        this.finding().enterLikelihood(fArray);
    }

    public int getFinding() throws NeticaException {
        return this.finding().getState();
    }

    public float[] getLikelihood() throws NeticaException {
        return this.finding().getLikelihood(null);
    }

    public double getValueEntered() throws NeticaException {
        return this.finding().getReal();
    }

    public void retractFindings() throws NeticaException {
        this.finding().clear();
    }

    static int[] stringToStates(String string, NodeList nodeList) throws NeticaException {
        if (string == null || string.length() == 0) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",< \t;:.(){}[]>");
        int[] nArray = new int[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("*")) {
                nArray[n++] = -5;
                continue;
            }
            Node node = (Node)nodeList.get(n);
            nArray[n] = node.state(string2).getIndex();
            ++n;
        }
        return nArray;
    }

    long getNodePtr() throws NeticaException {
        this.assertNodeIsViable();
        return this.nodePtr;
    }
}

