# -*- coding: utf-8 -*-
"""
Build the Chest Clinic example Bayes net and save it to a 
file in the 'Data Files' directory.

For netica version 6.05 or later

@author: Sophie
"""

import sys, os
sys.path.append(os.path.abspath('..'))
#import cairosvg
#import matplotlib as plt
from IPython.display import SVG
import neticapy as netica

env = netica.Environ()
print(env.mesg)

net = netica.Net("ChestClinic")

VisitAsia = net.new_node("VisitAsia", "visit, no_visit")
Tuberculosis = net.new_node("Tuberculosis", "present, absent")
Smoking = net.new_node("Smoking", "smoker, nonsmoker")
Cancer = net.new_node("Cancer", "present, absent")
TbOrCa = net.new_node("TbOrCa", "true, false")
XRay = net.new_node("XRay", "abnormal, normal")
Dyspnea = net.new_node("Dyspnea", "present, absent")
Bronchitis = net.new_node("Bronchitis", "present, absent")

TbOrCa.title = "Tuberculosis or Cancer"
Cancer.title = "Lung Cancer"

Tuberculosis.add_link_from(VisitAsia)
Cancer.add_link_from(Smoking)
TbOrCa.add_link_from(Tuberculosis)
TbOrCa.add_link_from(Cancer)
XRay.add_link_from(TbOrCa)
Dyspnea.add_link_from(TbOrCa)
Bronchitis.add_link_from(Smoking)
Dyspnea.add_link_from(Bronchitis)

VisitAsia.set_CPT(None, [0.01, 0.99])     

Tuberculosis.set_CPT("visit", [0.05, 0.95])
Tuberculosis.set_CPT("no_visit", [0.01, 0.99])

Smoking.set_CPT(None, [0.5, 0.5])

Cancer.set_CPT("smoker", [0.1, 0.9])
Cancer.set_CPT("nonsmoker", [0.01, 0.99])
	
VisitAsia.set_CPT(None, [0.01, 0.99])     

Tuberculosis.set_CPT("visit", [0.05, 0.95])
Tuberculosis.set_CPT("no_visit", [0.01, 0.99])

Smoking.set_CPT(None, [0.5, 0.5])

Cancer.set_CPT("smoker", [0.1, 0.9])
Cancer.set_CPT("nonsmoker", [0.01, 0.99])

Bronchitis.set_CPT("smoker", [0.1, 0.9])
Bronchitis.set_CPT("nonsmoker", [0.3, 0.7])

"""         |Tuberculosis| |Cancer|         """     
TbOrCa.set_CPT("present, present", [1.0, 0.0])
TbOrCa.set_CPT("present, absent", [1.0, 0.0])
TbOrCa.set_CPT("absent, present", [1.0, 0.0])
TbOrCa.set_CPT("absent, absent", [0.0, 1.0])

XRay.set_CPT("true",   [0.98,    0.02])
XRay.set_CPT("false",  [0.05,    0.95])

VisitAsia.set_CPT([1, 1, 0, 12], [0.01, 0.99])   

Dyspnea.set_CPT("true, present", [0.9, 0.1])
Dyspnea.set_CPT("true, absent", [0.7, 0.3])
Dyspnea.set_CPT("false, present", [0.8, 0.2])
Dyspnea.set_CPT("false, absent", [0.1, 0.9])

net.create_diagram(net.nodes, netica.Stream("Data Files/ChectClinicDiagram.svg"))
    
#print("Built the 'Chest Clinic' Bayes net and saved it as file 'Data Files/ChestClinic.dne'")

res, mesg = env.close_netica()
print('\n' + mesg)