# -*- coding: utf-8 -*-
"""
Reads in Bayes net 'ChestClinic.dne' built by the BuildNet example,
removes its CPTs, and then learns new ones from the casefile 'ChestClinic.cas'
(built by SimulateCases example).

It outputs the final net to file 'Learned_ChestClinic.dne'.

For netica version 6.05 or later

@author: Sophie
"""
import sys, os
sys.path.append(os.path.abspath('..'))
import neticapy as netica

env = netica.Environ()

orig_net = netica.Net(None, "Data Files/ChestClinic.dne")
orig_nodes = orig_net.nodes
orig_netauto_update = 0

learned_net = netica.Net("Learned_ChestClinic")
	
''' Read in the case file created by the the SimulateCases.py
	   example program, and learn new CPTables. '''

fname = "Data Files/ChestClinic.cas"
cases = netica.Caseset("AllCases")
cases.add_cases_from_file(fname)
learned_net.add_nodes_from_caseset(cases)

print(f"Created net from {fname} having {learned_net.nodes.length} nodes\n")


target = learned_net.get_node_named("Smoking")
learned_net.learn_tan_structure(learned_net.nodes, target, cases) # options="auto_layout"

#learner = netica.Learner("COUNTING")
#learner.learn_CPTs(nodes, cases, 1.0)

learned_net.revise_CPTs_by_case_file(fname, learned_net.nodes, 1)

learned_net.write(netica.Stream("Data Files/Learned_ChestClinicTAN.dne"))

print("Used the case file to learn all the CPTs, and put the resulting net in 'Data Files/Learned_ChestClinicTAN.cas'\n")

res, mesg = env.close_netica()
print('\n' + mesg)