# -*- coding: utf-8 -*-
"""
Reads in Bayes net 'ChestClinic.dne' built by the BuildNet example,
and uses it to simulate 200 random cases, which it outputs to file
'ChestClinic.cas'.

For netica version 6.05 or later

@author: Sophie
"""
import sys, os
sys.path.append(os.path.abspath('..'))
import os
import neticapy as netica

env = netica.Environ()
    
# Read in the net created by the BuildNet.py example program

orig_net = netica.Net(name=None, file="Data Files/ChestClinic.dne", options="NO_VISUAL_INFO")
orig_nodes = orig_net.nodes
orig_net.auto_update = 0

try:
    os.remove("Data Files/ChestClinic.cas")
except FileNotFoundError:
    pass

casefile = netica.Stream("Data Files/ChestClinic.cas")
numcases = 200
for i in range(numcases):
    orig_net.retract_findings()
    res = orig_net.generate_random_case(orig_nodes, "DEFAULT", 20, None)      
    if res >= 0:
        orig_net.write_findings(orig_nodes, casefile, i, -1)

print("Simulated 200 random cases from the Chest Clinic net, and put them in file 'Data Files/ChestClinic.cas'\n")

res, mesg = env.close_netica()
print(mesg)