# -*- coding: utf-8 -*-
"""
Do inference with Chest Clinic example program using Netica-Py

Reads in simple bayes net created by BuildNet.py and does bayesian inference

For netica version 6.05 or later

@author: Sophie
"""

import sys, os
sys.path.append(os.path.abspath('..\\src'))
import neticapy

env = neticapy.Environ()
res, mesg = env.init_netica()
print(mesg)
if res < 0:
    raise SystemExit

net = env.new_file_stream("Data Files\\ChestClinic.dne").read_net(neticapy.ReadingOption.NO_VISUAL_INFO)

net.compile_()

VisitAsia = net.get_node_named("VisitAsia")
Tuberculosis = net.get_node_named("Tuberculosis")
XRay = net.get_node_named("XRay")
Cancer = net.get_node_named("Cancer")

belief = Tuberculosis.get_beliefs()

print("\nThe probability of tuberculosis is %.6f" % belief[0])

XRay.enter_finding(0)

print("\nGiven an abnormal X-ray, \n\
         the probability of tuberculosis is %.6f" % 
         Tuberculosis.get_beliefs()[0]);

VisitAsia.enter_finding(0)

print("\nGiven an abnormal X-ray and a visit to Asia, \n\
	     the probability of tuberculosis is %.6f" % 
         Tuberculosis.get_beliefs()[0]);

Cancer.enter_finding(0)

print("\nGiven abnormal X-ray, Asia visit, and lung cancer, \n\
         the probability of tuberculosis is %.6f" % 
         Tuberculosis.get_beliefs()[0]);

net.delete()
res, mesg = env.close_netica()
print('\n' + mesg)