# -*- coding: utf-8 -*-
"""
Reads in Bayes net 'ChestClinic.dne' built by the BuildNet example,
removes its CPTs, and then learns new ones from the casefile 'ChestClinic.cas'
(built by SimulateCases example).

It outputs the final net to file 'Learned_ChestClinic.dne'.

For netica version 6.05 or later

@author: Sophie
"""
import sys, os
sys.path.append(os.path.abspath('../src'))
import neticapy

env = neticapy.Environ()
res, mesg = env.init_netica()
print(mesg)
if res < 0:
    raise SystemExit

orig_net = env.new_file_stream("Data Files/ChestClinic.dne").read_net(neticapy.ReadingOption.NO_VISUAL_INFO)
orig_nodes = orig_net.nodes
orig_netauto_update = 0

learned_net = env.new_net("Learned_ChestClinic")
learned_nodes = learned_net.copy_nodes(orig_nodes)
numnodes = learned_nodes.length

''' Remove CPTables of nodes in learned_net, so new ones can be learned. '''

for i in range(0, numnodes):
    learned_nodes.nth_node(i).delete_tables()
	
''' Read in the case file created by the the SimulateCases.py
	   example program, and learn new CPTables. '''

casefile = env.new_file_stream("Data Files/ChestClinic.cas")       
learned_net.revise_CPTs_by_case_file(casefile, learned_nodes, 1)

learned_net.write(env.new_file_stream("Data Files/Learned_ChestClinic.dne"))

print("Used the case file to learn all the CPTs, and put the resulting net in 'Data Files/Learned_ChestClinic.cas'\n")

learned_nodes.delete()
orig_net.delete()
learned_net.delete()
res, mesg = env.close_netica()
print('\n' + mesg)