# -*- coding: utf-8 -*-
"""
Read in the 'BreastCancer.dne' Bayes net, and enter data on 
a particular case to classify it as malignant or not.

@author: Sophie
"""
import neticapy as netica

env = netica.Environ()

net = netica.Net('BreastCancer', netica.Stream("Data Files/BreastCancer.dne"), options="NO_VISUAL_INFO")

Malignancy = net.get_node_named("Malignancy")
ClumpThickness = net.get_node_named("ClumpThickness")
UniformityOfCellSize = net.get_node_named("UniformityOfCellSize")
UniformityOfCellShape = net.get_node_named("UniformityOfCellShape")
MarginalAdhesion = net.get_node_named("MarginalAdhesion")
SingleEpithelialCellSize = net.get_node_named("SingleEpithelialCellSize")
BareNuclei = net.get_node_named("BareNuclei")
BlandChromatin = net.get_node_named("BlandChromatin")
NormalNucleoli = net.get_node_named("NormalNucleoli")
Mitoses = net.get_node_named("Mitoses")

nodes = net.nodes

""" Clear any CPT data """

for i in range(nodes.length):
    nodes.get_nth_node(i).delete_tables()

""" Train net based on database of Wisconsin breast cancer study """

net.revise_CPTs_by_case_file(netica.Stream("Data Files/BreastCancer.cas"), nodes, 1)

""" Now perform a classification for a particular case:  10,3,3,2,2,10,4,1,2 """

ClumpThickness.enter_value(10.0)
UniformityOfCellSize.enter_value(3.0)
UniformityOfCellShape.enter_value(3.0)
MarginalAdhesion.enter_value(2.0)
SingleEpithelialCellSize.enter_value(2.0)
BareNuclei.enter_value(10.0)
BlandChromatin.enter_value(4.0)
NormalNucleoli.enter_value(1.0)
Mitoses.enter_value(2.0)

net.compile_net()

print("\nThe probability of this cell being malignant is %g\n\n" % Malignancy.get_beliefs()[0])

res, mesg = env.close_netica()
print(mesg)
