# -*- coding: utf-8 -*-
"""
Created on Sun Mar 15 17:17:24 2020

@author: Sophie
"""

import ctypes
import os
import platform
import sys

#Netica = ctypes.WinDLL(os.path.abspath('./bin/Netica.dll'))

# New to Python version 3.7 (might want to check version before using?)
# Meant to replace pkg_resources - let's see if we can get it working!
# We may only distribute a package (uses setuptools anyways), so the 
# below may be sufficient for our distribution
# May be hard to get this to work
# My python version isn't recent enough!

# import importlib
# import importlibbin

# Netica = ctypes.WinDLL(importlib.resources.path(importlibbin, 'Netica.dll'))

# Relies on setuptools, previously worked when neticapy was packaged, not 
# tested since splitting the huge file

# from pkg_resources import resource_filename

# if sys.platform == "linux" or sys.platform == "linux2":
#     Netica = ctypes.cdll.LoadLibrary(resource_filename('neticapy', 'bin/libnetica.so'))
# elif sys.platform == "darwin":    
#     Netica = ctypes.cdll.LoadLibrary(resource_filename('neticapy', 'bin/libnetica.dylib'))
# elif sys.platform == "win32":
#     if platform.architecture()[0] == '64bit':
#         Netica = ctypes.WinDLL(resource_filename('neticapy', 'bin/Netica.dll'))
#     elif platform.architecture()[0] == '32bit':
#         Netica = ctypes.WinDLL(resource_filename('neticapy', 'bin/32bit/Netica.dll'))
# else:
#     raise OSError("Can't find the dll file Netica.dll, which should be contained \
#                   in /bin for 64 bit python or /bin/32bit for 32 bit python.") 


# This path is relative to where the example is being run, and therefore 
# isn't very flexible
# Could also somehow add bin to the PATH, or change directories

if sys.platform == "linux" or sys.platform == "linux2":
    Netica = ctypes.cdll.LoadLibrary(os.path.abspath('../bin/libnetica.so'))
elif sys.platform == "darwin":    
    Netica = ctypes.cdll.LoadLibrary(os.path.abspath('../bin/libnetica.dylib'))
elif sys.platform == "win32":
    if platform.architecture()[0] == '64bit':
        Netica = ctypes.WinDLL(os.path.abspath('../bin/Netica.dll'))
    elif platform.architecture()[0] == '32bit':
        Netica = ctypes.WinDLL(os.path.abspath('../bin/32bit/Netica.dll'))
else:
    raise OSError("Can't find the dll file Netica.dll, which should be contained \
                  in /bin for 64 bit python or /bin/32bit for 32 bit python.") 