/* 
 * Netica.h
 *
 * Header file for Netica API, version 1.05.
 *
 * Copyright (C) 1992-1997 by Norsys Software Corp.  All rights reserved.
 *
 */

#ifndef __Netica_h
#define __Netica_h

#ifdef __cplusplus
extern "C" {
#endif


#include <limits.h>      /* from the ANSI Standard C library */
#include <stdio.h>


#ifdef FALSE
typedef enum {FALSE_ns=0, TRUE_ns} bool_ns;
#else
typedef enum {FALSE=0, TRUE} bool_ns;
#endif

#define  INFINITY_ns  inf_dbl_ns
#define  UNDEF_DBL    undef_dbl_ns

#define  MESG_LEN_ns  256
#define  NAME_MAX_ns   30
enum    {QUERY_ns  =   -1};

typedef enum {NOTHING_ERR=1, REPORT_ERR, NOTICE_ERR, WARNING_ERR, ERROR_ERR, XXX_ERR} errdanger_ns;

typedef enum {NO_CHECK = 23, QUICK_CHECK, REGULAR_CHECK, COMPLETE_CHECK} checking_ns;

typedef enum {NATURE_NODE, ASSUME_NODE, DECISION_NODE, UTILITY_NODE, DISCONNECTED_NODE} nodekind_bn;

enum {WILDCARD_STATE = -5, IMPOSS_STATE, UNDEF_STATE};    /* special values for state_bn */

enum {NO_FINDING = -8, NEGATIVE_FINDING, LIKELIHOOD_FINDING};   /* for GetNodeFinding_bn */

enum {FIRST_CASE = -15, NEXT_CASE, NO_MORE_CASES};     /* special values for caseposn_bn */


typedef int     state_bn;
typedef float   prob_bn;
typedef double  level_bn;
typedef long    caseposn_bn;

typedef struct net__bn       net_bn;
typedef struct node__bn      node_bn;
typedef struct nodelist__bn  nodelist_bn;
typedef struct environ__ns   environ_ns;
typedef struct report__ns    report_ns;
typedef struct stream__ns    stream_ns;

extern const double inf_dbl_ns;    /* use INFINITY_ns in your software */
extern const double undef_dbl_ns;  /* use UNDEF_DBL   in your software */
extern double BaseExperience_bn;


environ_ns *NewNeticaEnviron_bn (const char *license);
int InitNetica_bn (environ_ns **envp, char *mesg);
int CloseNetica_bn (environ_ns *env, char *mesg);
int ArgumentChecking_ns (int setting, environ_ns *env);
int GetNeticaVersion_bn (environ_ns *env, const char **version);

report_ns *GetError_ns (environ_ns *env, errdanger_ns danger, const report_ns *after);
int ErrorNumber_ns (const report_ns *error);
const char *ErrorMessage_ns (const report_ns *error);
errdanger_ns ErrorDanger_ns (const report_ns *error);
report_ns *ReportError_ns (environ_ns *env, int number, errdanger_ns danger, const char *mesg);
void ClearError_ns (report_ns *error);
void ClearErrors_ns (environ_ns *env, errdanger_ns danger);

stream_ns *FileNamed_ns (const char *filename, environ_ns *env);
void WriteNet_bn (const net_bn *net, stream_ns *file);
net_bn *ReadNet_bn (stream_ns *file, bool_ns readvisual);
caseposn_bn WriteCase_bn (const nodelist_bn *nodes, stream_ns *file, long ID_num, double freq);
void ReadCase_bn (caseposn_bn *case_posn, stream_ns *file, const nodelist_bn *nodes, long *ID_num, double *freq);

void EnterFinding_bn (node_bn *node, state_bn state);
void EnterFindingNot_bn (node_bn *node, state_bn state);
void EnterNodeValue_bn (node_bn *node, double value);
void EnterNodeLikelihood_bn (node_bn *node, const prob_bn *likelihood);
state_bn GetNodeFinding_bn (const node_bn *node);
const prob_bn *GetNodeLikelihood_bn (const node_bn *node);
double GetNodeValue_bn (const node_bn *node);
void RetractNodeFindings_bn (node_bn *node);
void RetractAllFindings_bn (net_bn *net);

void CompileNet_bn (net_bn *net);
bool_ns IsBeliefUpdated_bn (const node_bn *node);
const prob_bn *GetNodeBeliefs_bn (node_bn *node);
double CaseProbability_bn (net_bn *net);
int RandomCase_bn (const nodelist_bn *nodes, int method, double num);

nodelist_bn *NewNodeList_bn (int length, environ_ns *env);
void AddNodeToList_bn (node_bn *node, nodelist_bn *nodes, int index);
node_bn *RemoveNthNode_bn (nodelist_bn *nodes, int index);
int LengthNodeList_bn (const nodelist_bn *nodes);
node_bn *NthNode_bn (const nodelist_bn *nodes, int index);
void SetNthNode_bn (nodelist_bn *nodes, int index, node_bn *node);
nodelist_bn *DupNodeList_bn (const nodelist_bn *nodes);
void FreeNodeList_bn (nodelist_bn *nodes);

void CaseRevisesProbs_bn (const nodelist_bn *nodes, int updating, double degree);
void CaseFileRevisesProbs_bn (stream_ns *file, const nodelist_bn *nodes, int updating, double degree);
void FadeProbs_bn (node_bn *node, double degree);

void ReverseLink_bn (node_bn *parent, node_bn *child);
void AbsorbNodes_bn (nodelist_bn *nodes);
void OptimizeDecisions_bn (const nodelist_bn *nodes);

net_bn *NewNet_bn (const char *name, environ_ns *env);
void FreeNet_bn (net_bn *net);
node_bn *NewNode_bn (const char *name, int num_states, net_bn *net);
nodelist_bn *DuplicateNodes_bn (const nodelist_bn *nodes, net_bn *new_net);
void DeleteNode_bn (node_bn *node);
int AddLink_bn (node_bn *parent, node_bn *child);
void DeleteLink_bn (int link_index, node_bn *child);
void SwitchNodeParent_bn (int link_index, node_bn *node, node_bn *new_parent);

void SetNetName_bn (net_bn *net, const char *name);
void SetNetAutoUpdate_bn (net_bn *net, int autoupdate);
void SetNetElimOrder_bn (net_bn *net, const nodelist_bn *elim_order);
void SetNetTitle_bn (net_bn *net, const char *title);
void SetNetComment_bn (net_bn *net, const char *comment);
void SetNetUserData_bn (net_bn *net, int kind, void *data);

void SetNodeName_bn (node_bn *node, const char *name);
void SetNodeKind_bn (node_bn *node, nodekind_bn kind);
void SetNodeStateName_bn (node_bn *node, state_bn state, const char *state_name);
void SetNodeLevels_bn (node_bn *node, int num_states, const level_bn *levels);
void SetLinkName_bn (node_bn *node, int link_index, const char *link_name);
void SetNodeProbs_bn (node_bn *node, const state_bn *parent_states, const prob_bn *probs);
void SetNodeFuncValue_bn (node_bn *node, const state_bn *parent_states, double func_value);
void SetNodeExperience_bn (node_bn *node, const state_bn *parent_states, double experience);
void DeleteNodeRelation_bn (node_bn *node);
void SetNodeTitle_bn (node_bn *node, const char *title);
void SetNodeComment_bn (node_bn *node, const char *comment);
void SetNodeUserData_bn (node_bn *node, int kind, void *data);

const char *GetNetName_bn (const net_bn *net);
const nodelist_bn *GetNetNodes_bn (const net_bn *net);
node_bn *NodeNamed_bn (const char *name, const net_bn *net);
int GetNetAutoUpdate_bn (const net_bn *net);
const nodelist_bn *GetNetElimOrder_bn (const net_bn *net);
const char *GetNetTitle_bn (const net_bn *net);
const char *GetNetComment_bn (const net_bn *net);
void *GetNetUserData_bn (const net_bn *net, int kind);

net_bn *GetNodeNet_bn (const node_bn *node);
const char *GetNodeName_bn (const node_bn *node);
nodekind_bn GetNodeKind_bn (const node_bn *node);
bool_ns GetNodeDiscrete_bn (const node_bn *node);
int GetNodeNumberStates_bn (const node_bn *node);
const char *GetNodeStateName_bn (const node_bn *node, state_bn state);
state_bn StateNamed_bn (const char *name, const node_bn *node);
level_bn GetNodeLevel_bn (const node_bn *node, state_bn state);
const nodelist_bn *GetNodeParents_bn (const node_bn *node);
const nodelist_bn *GetNodeChildren_bn (const node_bn *node);
const char *GetLinkName_bn (const node_bn *node, int link_index);
int LinkNamed_bn (const char *name, const node_bn *node);
bool_ns HasRelation_bn (const node_bn *node);
bool_ns IsNodeDeterministic_bn (const node_bn *node);
const prob_bn *GetNodeProbs_bn (const node_bn *node, const state_bn *parent_states);
double GetNodeFuncValue_bn (const node_bn *node, const state_bn *parent_states);
double GetNodeExperience_bn (const node_bn *node, const state_bn *parent_states);
const char *GetNodeTitle_bn (const node_bn *node);
const char *GetNodeComment_bn (const node_bn *node);
void *GetNodeUserData_bn (const node_bn *node, int kind);


#ifdef __cplusplus
}
#endif

#endif  /* __Netica_h */
