/* 
 * Netica.h
 *
 * Header file for Netica API (as Win32 DLL), version 1.06.
 * This is not for Netica static library
 *   (unless you #define STATIC_LINK before #including this file)
 *
 * Copyright (C) 1992-1997 by Norsys Software Corp.  All rights reserved.
 */

#ifndef __Netica_h
#define __Netica_h

#ifdef __cplusplus
extern "C" {
#endif

#ifndef STATIC_LINK
#define IMPORT(typ) __declspec (dllimport) typ __stdcall
#define IMPORT_VAR  __declspec (dllimport)
#else
#define IMPORT(typ) typ
#define IMPORT_VAR
#endif


#include <limits.h>      /* from the ANSI Standard C library */
#include <stdio.h>


#ifndef FALSE
enum {FALSE=0, TRUE};
#endif

typedef unsigned char bool_ns;

#define  INFINITY_ns  inf_dbl_ns
#define  UNDEF_DBL    undef_dbl_ns

#define  MESG_LEN_ns  256
#define  NAME_MAX_ns   30
enum    {QUERY_ns  =   -1};

typedef enum {NOTHING_ERR=1, REPORT_ERR, NOTICE_ERR, WARNING_ERR, ERROR_ERR, XXX_ERR} errdanger_ns;

typedef enum {NO_CHECK = 23, QUICK_CHECK, REGULAR_CHECK, COMPLETE_CHECK} checking_ns;

typedef enum {NATURE_NODE, ASSUME_NODE, DECISION_NODE, UTILITY_NODE, DISCONNECTED_NODE} nodekind_bn;

enum {WILDCARD_STATE = -5, IMPOSS_STATE, UNDEF_STATE};    /* special values for state_bn */

enum {NO_FINDING = -8, NEGATIVE_FINDING, LIKELIHOOD_FINDING};   /* for GetNodeFinding_bn */

enum {FIRST_CASE = -15, NEXT_CASE, NO_MORE_CASES};     /* special values for caseposn_bn */


typedef int     state_bn;
typedef float   prob_bn;
typedef double  level_bn;
typedef long    caseposn_bn;

typedef struct net__bn       net_bn;
typedef struct node__bn      node_bn;
typedef struct nodelist__bn  nodelist_bn;
typedef struct environ__ns   environ_ns;
typedef struct report__ns    report_ns;
typedef struct stream__ns    stream_ns;

extern IMPORT_VAR const double inf_dbl_ns;    /* use INFINITY_ns in your software */
extern IMPORT_VAR const double undef_dbl_ns;  /* use UNDEF_DBL   in your software */
extern IMPORT_VAR double BaseExperience_bn;


IMPORT (environ_ns *) NewNeticaEnviron_bn (const char *license);
IMPORT (int) InitNetica_bn (environ_ns **envp, char *mesg);
IMPORT (int) CloseNetica_bn (environ_ns *env, char *mesg);
IMPORT (int) ArgumentChecking_ns (int setting, environ_ns *env);
IMPORT (int) GetNeticaVersion_bn (environ_ns *env, const char **version);

IMPORT (report_ns *) GetError_ns (environ_ns *env, errdanger_ns danger, const report_ns *after);
IMPORT (int) ErrorNumber_ns (const report_ns *error);
IMPORT (const char *) ErrorMessage_ns (const report_ns *error);
IMPORT (errdanger_ns) ErrorDanger_ns (const report_ns *error);
IMPORT (report_ns *) ReportError_ns (environ_ns *env, int number, errdanger_ns danger, const char *mesg);
IMPORT (void) ClearError_ns (report_ns *error);
IMPORT (void) ClearErrors_ns (environ_ns *env, errdanger_ns danger);

IMPORT (stream_ns *) FileNamed_ns (const char *filename, environ_ns *env);
IMPORT (void) WriteNet_bn (const net_bn *net, stream_ns *file);
IMPORT (net_bn *) ReadNet_bn (stream_ns *file, bool_ns readvisual);
IMPORT (caseposn_bn) WriteCase_bn (const nodelist_bn *nodes, stream_ns *file, long ID_num, double freq);
IMPORT (void) ReadCase_bn (caseposn_bn *case_posn, stream_ns *file, const nodelist_bn *nodes, long *ID_num, double *freq);

IMPORT (void) EnterFinding_bn (node_bn *node, state_bn state);
IMPORT (void) EnterFindingNot_bn (node_bn *node, state_bn state);
IMPORT (void) EnterNodeValue_bn (node_bn *node, double value);
IMPORT (void) EnterNodeLikelihood_bn (node_bn *node, const prob_bn *likelihood);
IMPORT (state_bn) GetNodeFinding_bn (const node_bn *node);
IMPORT (const prob_bn *) GetNodeLikelihood_bn (const node_bn *node);
IMPORT (double) GetNodeValue_bn (const node_bn *node);
IMPORT (void) RetractNodeFindings_bn (node_bn *node);
IMPORT (void) RetractAllFindings_bn (net_bn *net);

IMPORT (void) CompileNet_bn (net_bn *net);
IMPORT (bool_ns) IsBeliefUpdated_bn (const node_bn *node);
IMPORT (const prob_bn *) GetNodeBeliefs_bn (node_bn *node);
IMPORT (double) CaseProbability_bn (net_bn *net);
IMPORT (int) RandomCase_bn (const nodelist_bn *nodes, int method, double num);

IMPORT (nodelist_bn *) NewNodeList_bn (int length, environ_ns *env);
IMPORT (void) AddNodeToList_bn (node_bn *node, nodelist_bn *nodes, int index);
IMPORT (node_bn *) RemoveNthNode_bn (nodelist_bn *nodes, int index);
IMPORT (int) LengthNodeList_bn (const nodelist_bn *nodes);
IMPORT (node_bn *) NthNode_bn (const nodelist_bn *nodes, int index);
IMPORT (void) SetNthNode_bn (nodelist_bn *nodes, int index, node_bn *node);
IMPORT (nodelist_bn *)DupNodeList_bn (const nodelist_bn *nodes);
IMPORT (void) FreeNodeList_bn (nodelist_bn *nodes);

IMPORT (void) CaseRevisesProbs_bn (const nodelist_bn *nodes, int updating, double degree);
IMPORT (void) CaseFileRevisesProbs_bn (stream_ns *file, const nodelist_bn *nodes, int updating, double degree);
IMPORT (void) FadeProbs_bn (node_bn *node, double degree);

IMPORT (void) ReverseLink_bn (node_bn *parent, node_bn *child);
IMPORT (void) AbsorbNodes_bn (nodelist_bn *nodes);
IMPORT (void) OptimizeDecisions_bn (const nodelist_bn *nodes);

IMPORT (net_bn *) NewNet_bn (const char *name, environ_ns *env);
IMPORT (void) FreeNet_bn (net_bn *net);
IMPORT (node_bn *) NewNode_bn (const char *name, int num_states, net_bn *net);
IMPORT (nodelist_bn *) DuplicateNodes_bn (const nodelist_bn *nodes, net_bn *new_net);
IMPORT (void) DeleteNode_bn (node_bn *node);
IMPORT (int) AddLink_bn (node_bn *parent, node_bn *child);
IMPORT (void) DeleteLink_bn (int link_index, node_bn *child);
IMPORT (void) SwitchNodeParent_bn (int link_index, node_bn *node, node_bn *new_parent);

IMPORT (void) SetNetName_bn (net_bn *net, const char *name);
IMPORT (void) SetNetAutoUpdate_bn (net_bn *net, int autoupdate);
IMPORT (void) SetNetElimOrder_bn (net_bn *net, const nodelist_bn *elim_order);
IMPORT (void) SetNetTitle_bn (net_bn *net, const char *title);
IMPORT (void) SetNetComment_bn (net_bn *net, const char *comment);
IMPORT (void) SetNetUserData_bn (net_bn *net, int kind, void *data);

IMPORT (void) SetNodeName_bn (node_bn *node, const char *name);
IMPORT (void) SetNodeKind_bn (node_bn *node, nodekind_bn kind);
IMPORT (void) SetNodeStateName_bn (node_bn *node, state_bn state, const char *state_name);
IMPORT (void) SetNodeLevels_bn (node_bn *node, int num_states, const level_bn *levels);
IMPORT (void) SetLinkName_bn (node_bn *node, int link_index, const char *link_name);
IMPORT (void) SetNodeProbs_bn (node_bn *node, const state_bn *parent_states, const prob_bn *probs);
IMPORT (void) SetNodeFuncValue_bn (node_bn *node, const state_bn *parent_states, double func_value);
IMPORT (void) SetNodeExperience_bn (node_bn *node, const state_bn *parent_states, double experience);
IMPORT (void) DeleteNodeRelation_bn (node_bn *node);
IMPORT (void) SetNodeTitle_bn (node_bn *node, const char *title);
IMPORT (void) SetNodeComment_bn (node_bn *node, const char *comment);
IMPORT (void) SetNodeUserData_bn (node_bn *node, int kind, void *data);

IMPORT (const char *) GetNetName_bn (const net_bn *net);
IMPORT (const nodelist_bn *) GetNetNodes_bn (const net_bn *net);
IMPORT (node_bn *) NodeNamed_bn (const char *name, const net_bn *net);
IMPORT (int) GetNetAutoUpdate_bn (const net_bn *net);
IMPORT (const nodelist_bn *) GetNetElimOrder_bn (const net_bn *net);
IMPORT (const char *) GetNetTitle_bn (const net_bn *net);
IMPORT (const char *) GetNetComment_bn (const net_bn *net);
IMPORT (void *) GetNetUserData_bn (const net_bn *net, int kind);

IMPORT (net_bn *) GetNodeNet_bn (const node_bn *node);
IMPORT (const char *) GetNodeName_bn (const node_bn *node);
IMPORT (nodekind_bn) GetNodeKind_bn (const node_bn *node);
IMPORT (bool_ns) GetNodeDiscrete_bn (const node_bn *node);
IMPORT (int) GetNodeNumberStates_bn (const node_bn *node);
IMPORT (const char *) GetNodeStateName_bn (const node_bn *node, state_bn state);
IMPORT (state_bn) StateNamed_bn (const char *name, const node_bn *node);
IMPORT (level_bn) GetNodeLevel_bn (const node_bn *node, state_bn state);
IMPORT (const nodelist_bn *) GetNodeParents_bn (const node_bn *node);
IMPORT (const nodelist_bn *) GetNodeChildren_bn (const node_bn *node);
IMPORT (const char *) GetLinkName_bn (const node_bn *node, int link_index);
IMPORT (int) LinkNamed_bn (const char *name, const node_bn *node);
IMPORT (bool_ns) HasRelation_bn (const node_bn *node);
IMPORT (bool_ns) IsNodeDeterministic_bn (const node_bn *node);
IMPORT (const prob_bn *) GetNodeProbs_bn (const node_bn *node, const state_bn *parent_states);
IMPORT (double) GetNodeFuncValue_bn (const node_bn *node, const state_bn *parent_states);
IMPORT (double) GetNodeExperience_bn (const node_bn *node, const state_bn *parent_states);
IMPORT (const char *) GetNodeTitle_bn (const node_bn *node);
IMPORT (const char *) GetNodeComment_bn (const node_bn *node);
IMPORT (void *) GetNodeUserData_bn (const node_bn *node, int kind);


#ifdef __cplusplus
}
#endif

#endif  /* __Netica_h */
