/* 
 * NeticaEx.h
 *
 * Header for NeticaEx.c, 
 * which contains extra source code for Netica API, version 1.06.
 *
 * Copyright (C) 1992-1997 by Norsys Software Corp.  All rights reserved.
 *
 */

#ifndef __NeticaEx_h
#define __NeticaEx_h

#ifdef __cplusplus
extern "C" {
#endif

#define CHKERR  {if (GetError_ns (env, ERROR_ERR, NULL))  goto error;}

extern environ_ns *env;

int main_ex (void);

node_bn *NodeNamed (char *node_name, net_bn *net);
void EnterFinding (char *node_name, char *state_name, net_bn *net);
double GetNodeBelief (char *node_name, char *state_name, net_bn *net);
void SetNodeStateNames (node_bn *node, ...);
void SetNodeProbs (node_bn *node, ...);
void SetNodeFuncValue (node_bn *node, double value, ...);
void MakeProbsUniform (node_bn *node);
void GetNodeAllProbs (node_bn *node, prob_bn *probs);
void SetNodeAllProbs (node_bn *node, const prob_bn *probs);
double SizeCartesianProduct (const nodelist_bn *nodes);
node_bn *FormCliqueWith (const nodelist_bn *nodes);
report_ns *ReportError (environ_ns *env, int number, errdanger_ns danger, const char *mesg, ...);
int PositionInNodeList (const node_bn *node, const nodelist_bn *nodes);
void DeleteLinks (node_bn *parent, node_bn *child);
void DeleteLinksEntering (node_bn *child);
void SwitchNodeParent (node_bn *parent, node_bn *child, node_bn *new_parent);
void DeleteNodes (nodelist_bn *nodes);
bool_ns IsLinkDisconnected (int link_index, const node_bn *node);

bool_ns NextStates (state_bn *states, const nodelist_bn *nodes);
void ChangeFinding (node_bn *node, state_bn state);
nodelist_bn *TransferNodes (nodelist_bn *nodes, net_bn *new_net);
node_bn *DupNode (node_bn *node);
node_bn *DuplicateNode (node_bn *node, net_bn *new_net);
net_bn *DuplicateNet (net_bn *net, const char *newname);
node_bn *MapNode (const node_bn *node, const net_bn *dest_net);
nodelist_bn *MapNodeList (const nodelist_bn *nodes, const net_bn *dest_net);
nodelist_bn *MapNodeList1 (const nodelist_bn *oldorder, const nodelist_bn *oldnodes, const nodelist_bn *newnodes);
void AbsorbNode (node_bn *node);
void FadeProbsNodes (const nodelist_bn *nodes, double degree);
void PrintNeticaVersion (void);
void RemoveNodeFromList (node_bn *node, nodelist_bn *nodes);
void RemoveNthNodeFast (int index, nodelist_bn *nodes);
void PrintNodeList (nodelist_bn *nodes);
void PrintErrors (void);
void ClearErrors (environ_ns *env, errdanger_ns danger);
long CountCasesInFile (stream_ns *casefile);

nodelist_bn *DisconnectNodeGroup (nodelist_bn *nodes);
char *NodeListToString (const nodelist_bn *nodes);


#ifdef __cplusplus
}
#endif

#endif  /* __NeticaEx_h */
