/*
 * Decompiled with CFR 0.152.
 */
package norsys.netica.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.JPanel;
import norsys.netica.Net;
import norsys.netica.NeticaEvent;
import norsys.netica.NeticaException;
import norsys.netica.NeticaListener;
import norsys.netica.Node;
import norsys.netica.NodeList;
import norsys.netica.gui.DataDisplayer;
import norsys.netica.gui.LinkGraphic;
import norsys.netica.gui.NodePanel;
import norsys.netica.gui.RecursingEventListener;

public class NetPanel
extends JPanel
implements RecursingEventListener,
EventListener,
DataDisplayer,
NeticaListener {
    public static final int LINK_POLICY_NONE = 0;
    public static final int LINK_POLICY_BELOW = 1;
    public static final int LINK_POLICY_ABOVE = 2;
    public static Color defaultBackgroundColor = Color.white;
    public static Color defaultForegroundColor = Color.black;
    public static Color defaultLinkColor = Color.black;
    public static int defaultLinkPolicy = 1;
    public static int defaultLinkWidth = 1;
    Net parentNet;
    Vector links;
    HashSet eventListeners = new HashSet();
    NodeList subNetNodes = null;
    boolean linksVisible = true;
    int linkPolicy = defaultLinkPolicy;
    int nodeStyle;

    public NetPanel(Net net, int n) throws Exception {
        this.parentNet = net;
        this.nodeStyle = n;
        net.addListener(this);
        this.setupPanel();
    }

    @Override
    public void addListenerToAllComponents(EventListener eventListener) {
        if (eventListener == null) {
            return;
        }
        this.eventListeners.add(eventListener);
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (eventListener instanceof MouseMotionListener) {
                componentArray[i].addMouseMotionListener((MouseMotionListener)eventListener);
            }
            if (eventListener instanceof MouseListener) {
                componentArray[i].addMouseListener((MouseListener)eventListener);
            }
            if (!(componentArray[i] instanceof RecursingEventListener)) continue;
            ((RecursingEventListener)((Object)componentArray[i])).addListenerToAllComponents(eventListener);
        }
        if (eventListener instanceof MouseListener) {
            this.attachMouseListenerToLinks((MouseListener)eventListener);
        }
    }

    @Override
    public void eventOccurred(NeticaEvent neticaEvent) {
        if (neticaEvent.getObject().equals(this.parentNet) && neticaEvent.getKind() == 4) {
            this.setVisible(false);
            this.removeAll();
            this.links.clear();
            this.subNetNodes = null;
        } else if (neticaEvent.getObject() instanceof Node && neticaEvent.getKind() == 4) {
            System.err.println(" NODE DELETION DETECTED !!!!!!");
        }
    }

    public Net getNet() {
        return this.parentNet;
    }

    public NodePanel[] getNodePanels() {
        Object object;
        Component[] componentArray = this.getComponents();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof NodePanel)) continue;
            object = (NodePanel)componentArray[i];
            arrayList.add(object);
        }
        NodePanel[] nodePanelArray = new NodePanel[arrayList.size()];
        object = arrayList.iterator();
        int n = 0;
        while (object.hasNext()) {
            nodePanelArray[n++] = (NodePanel)object.next();
        }
        return nodePanelArray;
    }

    public NodeList getNodesWithDisplayMode(int n) throws Exception {
        if (n != 0 && n != 1 && n != 2) {
            throw new NeticaException("Invalid NodePanel display mode: " + n);
        }
        NodeList nodeList = new NodeList(this.parentNet);
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            NodePanel nodePanel;
            if (!(componentArray[i] instanceof NodePanel) || (nodePanel = (NodePanel)componentArray[i]).getDisplayMode() != n) continue;
            nodeList.add(nodePanel.getNode());
        }
        return nodeList;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(this.getBackground());
        graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics2D.setColor(this.getForeground());
        if (this.linkPolicy == 1) {
            this.drawLinks(graphics2D);
        }
        super.paintComponent(graphics2D);
        if (this.linkPolicy == 2) {
            this.drawLinks(graphics2D);
        }
    }

    @Override
    public void refreshDataDisplayed() throws NeticaException {
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof DataDisplayer)) continue;
            DataDisplayer dataDisplayer = (DataDisplayer)((Object)componentArray[i]);
            dataDisplayer.refreshDataDisplayed();
        }
        for (DataDisplayer dataDisplayer : this.links) {
            ((LinkGraphic)dataDisplayer).refreshDataDisplayed();
        }
        this.repaint();
    }

    @Override
    public void remove(Component component) {
        Vector<LinkGraphic> vector = new Vector<LinkGraphic>();
        if (component instanceof NodePanel) {
            for (LinkGraphic linkGraphic : this.links) {
                if (linkGraphic.getChildNodePanel() != component && linkGraphic.getParentNodePanel() != component) continue;
                vector.add(linkGraphic);
            }
        }
        for (LinkGraphic linkGraphic : vector) {
            this.links.remove(linkGraphic);
        }
        super.remove(component);
        this.repaint();
    }

    @Override
    public void removeListenerFromAllComponents(EventListener eventListener) {
        this.eventListeners.remove(eventListener);
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (eventListener instanceof MouseMotionListener) {
                componentArray[i].removeMouseMotionListener((MouseMotionListener)eventListener);
            }
            if (eventListener instanceof MouseListener) {
                componentArray[i].removeMouseListener((MouseListener)eventListener);
            }
            if (!(componentArray[i] instanceof RecursingEventListener)) continue;
            ((RecursingEventListener)((Object)componentArray[i])).removeListenerFromAllComponents(eventListener);
        }
    }

    public Vector getLinkGraphics() {
        return this.links;
    }

    public void replaceNodePanel(NodePanel nodePanel, NodePanel nodePanel2) throws NeticaException {
        if (nodePanel.getNode().getNet() != this.getNet()) {
            throw new NeticaException("The (original) NodePanel for " + nodePanel.getNode().getName() + " is not a member of this NetPanel");
        }
        if (nodePanel.getNode() != nodePanel2.getNode()) {
            throw new NeticaException("The two nodePanels are not for the same Netica Node.");
        }
        this.remove(nodePanel);
        this.addNodePanel(nodePanel2);
        this.attachEventListenersToComponent(nodePanel2);
        this.createLinks();
        this.attachEventListenersToLinks();
        this.revalidate();
    }

    public void setLinkPolicy(int n) {
        this.linkPolicy = n;
        if (this.isVisible()) {
            this.repaint();
        }
    }

    public void setSubnet(NodeList nodeList) throws Exception {
        this.subNetNodes = nodeList;
        this.removeAll();
        this.setupPanel();
        this.revalidate();
        this.repaint();
    }

    public void setNodeStyle(NodeList nodeList, int n) throws Exception {
        if (nodeList == null) {
            if (n != this.nodeStyle) {
                this.removeAll();
                this.nodeStyle = n;
                this.setupPanel();
            }
        } else {
            this.nodeStyle = -1;
            Component[] componentArray = this.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                NodePanel nodePanel;
                Node node;
                if (!(componentArray[i] instanceof NodePanel) || !nodeList.contains(node = (nodePanel = (NodePanel)componentArray[i]).getNode())) continue;
                NodePanel nodePanel2 = NodePanel.createNodePanel(node, n);
                this.replaceNodePanel(nodePanel, nodePanel2);
            }
        }
        this.revalidate();
        this.repaint();
    }

    void attachEventListenersToAllComponents() {
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            this.attachEventListenersToComponent(componentArray[i]);
        }
        this.attachEventListenersToLinks();
    }

    void attachEventListenersToLinks() {
        for (EventListener eventListener : this.eventListeners) {
            if (!(eventListener instanceof MouseListener)) continue;
            this.attachMouseListenerToLinks((MouseListener)eventListener);
        }
    }

    void attachMouseListenerToLinks(MouseListener mouseListener) {
        for (LinkGraphic linkGraphic : this.links) {
            linkGraphic.addMouseListener(mouseListener);
        }
    }

    void attachEventListenersToComponent(Component component) {
        for (EventListener eventListener : this.eventListeners) {
            if (eventListener instanceof MouseMotionListener) {
                component.addMouseMotionListener((MouseMotionListener)eventListener);
            }
            if (eventListener instanceof MouseListener) {
                component.addMouseListener((MouseListener)eventListener);
            }
            if (!(component instanceof RecursingEventListener)) continue;
            ((RecursingEventListener)((Object)component)).addListenerToAllComponents(eventListener);
        }
    }

    void setupPanel() throws Exception {
        this.setLayout(null);
        this.setBackground(defaultBackgroundColor);
        this.setForeground(defaultForegroundColor);
        NodeList nodeList = this.subNetNodes == null ? this.parentNet.getNodes() : this.subNetNodes;
        this.setOpaque(false);
        Enumeration enumeration = nodeList.elements();
        Rectangle rectangle = new Rectangle();
        while (enumeration.hasMoreElements()) {
            Node node = (Node)enumeration.nextElement();
            NodePanel nodePanel = NodePanel.createNodePanel(node, this.nodeStyle);
            this.addNodePanel(nodePanel);
            rectangle.add(nodePanel.getBounds());
        }
        this.doLayout();
        this.createLinks();
        this.attachEventListenersToAllComponents();
        this.setPreferredSize(rectangle.getSize());
    }

    void addNodePanel(NodePanel nodePanel) throws NeticaException {
        if (nodePanel != null) {
            double[] dArray = nodePanel.getNode().visual().getPosition();
            int n = (int)dArray[0];
            int n2 = (int)dArray[1];
            nodePanel.setBounds(n - nodePanel.getWidth() / 2, n2 - nodePanel.getHeight() / 2, nodePanel.getWidth(), nodePanel.getHeight());
            this.add(nodePanel);
        }
    }

    void drawLinks(Graphics graphics) {
        Point point = new Point();
        Point point2 = new Point();
        for (LinkGraphic linkGraphic : this.links) {
            if (!linkGraphic.isVisible()) continue;
            linkGraphic.paint(graphics);
        }
    }

    void createLinks() throws NeticaException {
        Component[] componentArray = this.getComponents();
        this.links = new Vector();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof NodePanel)) continue;
            NodePanel nodePanel = (NodePanel)componentArray[i];
            Node node = nodePanel.getNode();
            Rectangle rectangle = nodePanel.getBounds();
            NodeList nodeList = node.getParents();
            for (int j = 0; j < componentArray.length; ++j) {
                NodePanel nodePanel2;
                Node node2;
                if (!(componentArray[j] instanceof NodePanel) || !nodeList.contains(node2 = (nodePanel2 = (NodePanel)componentArray[j]).getNode())) continue;
                this.links.add(new LinkGraphic(this, nodePanel, nodePanel2));
            }
        }
    }
}

