/*
 * Decompiled with CFR 0.152.
 */
package norsys.netica.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.EventListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import norsys.netica.Environ;
import norsys.netica.NeticaException;
import norsys.netica.Node;
import norsys.netica.gui.DataDisplayer;
import norsys.netica.gui.NodePanel;
import norsys.netica.gui.NodePanel_BeliefBarsRow;
import norsys.netica.gui.RecursingEventListener;

public class NodePanel_BeliefBars
extends NodePanel {
    public static Color defaultBackgroundColor = null;
    public static Color defaultForegroundColor = NodePanel.defaultForegroundColor;
    public static Color defaultBorderColor = NodePanel.defaultBorderColor;
    public static Font defaultTitleFont = NodePanel.defaultTitleFont;
    public static Border defaultTitleBorder = NodePanel.defaultTitleBorder;
    public static int minWidth = 180;
    public static int maxWidth = 500;
    public static Color defaultBbBarsAreaColor = new Color(192, 220, 192);
    public static Color defaultBbBarsColor = Color.black;
    public static int defaultBbItemHeight = 13;
    public static int defaultBbBarsAreaWidth = 50;
    public static int defaultBbBarHeight = 8;
    public static int MAX_STATES_DISPLAYED = 10;
    public BBRowsPanel rowsPanel = new BBRowsPanel();
    public JLabel continuousInfoJLabel;
    Color borderColor = defaultBorderColor;
    Color bbBarsAreaColor = defaultBbBarsAreaColor;
    Color bbBarsColor = defaultBbBarsColor;
    int bbBarHeight = defaultBbBarHeight;
    int bbItemHeight = defaultBbItemHeight;
    int bbBarsAreaWidth = defaultBbBarsAreaWidth;
    int nStates;
    int nRows = 0;
    boolean floatsAvailable = true;
    float[] floats = null;
    float[] norm_floats = null;

    public NodePanel_BeliefBars(Node node) throws Exception {
        super(node);
        this.style = 4;
        this.setupPanel();
    }

    @Override
    protected void setupPanel() throws Exception {
        double d;
        super.setupPanel();
        this.nStates = this.parentNode.getNumStates();
        this.nRows = Math.min(this.nStates, MAX_STATES_DISPLAYED);
        if (this.nRows < 0) {
            this.nRows = 0;
        }
        if (defaultBackgroundColor != null) {
            this.setBackground(defaultBackgroundColor);
        }
        this.setLayout(new BorderLayout());
        String string = this.parentNode.getTitle();
        if (string.equals("")) {
            string = this.parentNode.getName();
        }
        this.nodeTitleJLabel = new JLabel(string, 0);
        this.nodeTitleJLabel.setBackground(null);
        this.nodeTitleJLabel.setForeground(null);
        this.nodeTitleJLabel.setFont(defaultTitleFont);
        this.nodeTitleJLabel.setBorder(defaultTitleBorder);
        this.add((Component)this.nodeTitleJLabel, "North");
        if (this.nStates == 0) {
            this.nRows = 3;
            this.rowsPanel.setLayout(new GridLayout(this.nRows, 1));
        } else {
            this.floats = this.getFloats();
            this.norm_floats = this.normalize(this.floats, this.nodeKind == 201);
            this.rowsPanel.setLayout(new GridLayout(this.nRows, 1));
            for (int i = 0; i < this.nRows; ++i) {
                NodePanel_BeliefBarsRow nodePanel_BeliefBarsRow = new NodePanel_BeliefBarsRow(this, this.parentNode.state(i));
                this.rowsPanel.add(nodePanel_BeliefBarsRow);
            }
            this.rowsPanel.setBorder(null);
            this.add((Component)this.rowsPanel, "Center");
            if (this.nRows < this.nStates) {
                this.add(new JLabel("..."));
            }
        }
        if (this.parentNode.getType() == 101 && (d = this.parentNode.calcValue()) != Environ.UNDEF_DBL) {
            String string2 = "" + this.parentNode.calcValue();
            this.continuousInfoJLabel = new JLabel(string2, 0);
            this.add((Component)this.continuousInfoJLabel, "South");
        }
        this.doLayout();
        this.setSize(this.getPreferredSize());
        if (this.getPreferredSize().width < minWidth) {
            this.setSize(minWidth, this.getHeight());
        }
        if (this.getPreferredSize().width > maxWidth) {
            this.setSize(maxWidth, this.getHeight());
        }
    }

    float[] normalize(float[] fArray, boolean bl) {
        if (fArray == null) {
            return null;
        }
        float[] fArray2 = new float[fArray.length];
        if (bl) {
            int n;
            float f = 0.0f;
            for (n = 0; n < fArray.length; ++n) {
                f += fArray[n];
            }
            if (f == 0.0f) {
                for (n = 0; n < fArray.length; ++n) {
                    fArray2[n] = 1.0f / (float)fArray.length;
                }
            } else {
                for (n = 0; n < fArray.length; ++n) {
                    fArray2[n] = fArray[n] / f;
                }
            }
        } else {
            float f = Float.MAX_VALUE;
            float f2 = Float.MIN_VALUE;
            for (int i = 0; i < fArray.length; ++i) {
                if (fArray[i] < f) {
                    f = fArray[i];
                }
                if (!(fArray[i] > f2)) continue;
                f2 = fArray[i];
            }
            float f3 = f2 - f;
            if (f3 == 0.0f) {
                for (int i = 0; i < fArray.length; ++i) {
                    fArray2[i] = 1.0f / (float)fArray.length;
                }
            } else {
                for (int i = 0; i < fArray.length; ++i) {
                    fArray2[i] = 0.6f * (fArray[i] - f) / f3 + 0.2f;
                }
            }
        }
        return fArray2;
    }

    float[] getFloats() {
        float[] fArray;
        block4: {
            fArray = null;
            String string = null;
            this.floatsAvailable = true;
            try {
                string = this.parentNode.getName();
                if (this.nodeKind == 203) {
                    fArray = this.parentNode.getExpectedUtils();
                    break block4;
                }
                if (this.nodeKind != 201) break block4;
                fArray = this.parentNode.getBeliefs();
            }
            catch (NeticaException neticaException) {
                this.floatsAvailable = false;
                if (this.nodeKind != 201) break block4;
                fArray = new float[this.nStates];
                for (int i = 0; i < this.nStates; ++i) {
                    fArray[i] = 1.0f / (float)this.nStates;
                }
            }
        }
        return fArray;
    }

    @Override
    public void refreshDataDisplayed() throws NeticaException {
        super.refreshDataDisplayed();
        if (this.getNode() == null) {
            return;
        }
        this.floats = this.getFloats();
        this.norm_floats = this.normalize(this.floats, this.nodeKind == 201);
        Component[] componentArray = this.rowsPanel.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof DataDisplayer)) continue;
            DataDisplayer dataDisplayer = (DataDisplayer)((Object)componentArray[i]);
            dataDisplayer.refreshDataDisplayed();
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        try {
            if (this.getNode() == null) {
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.paintComponent(graphics);
        graphics.setColor(defaultBorderColor);
        int n = this.nodeTitleJLabel.getHeight();
        graphics.drawLine(0, n, this.getWidth(), n);
        if (this.continuousInfoJLabel != null) {
            n = this.getHeight() - this.continuousInfoJLabel.getHeight() - 1;
            graphics.drawLine(0, n, this.getWidth(), n);
        }
    }

    class BBRowsPanel
    extends JPanel
    implements RecursingEventListener {
        BBRowsPanel() {
        }

        @Override
        public void addListenerToAllComponents(EventListener eventListener) {
            Component[] componentArray = this.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                if (eventListener instanceof MouseMotionListener) {
                    componentArray[i].addMouseMotionListener((MouseMotionListener)eventListener);
                }
                if (eventListener instanceof MouseListener) {
                    componentArray[i].addMouseListener((MouseListener)eventListener);
                }
                if (!(componentArray[i] instanceof RecursingEventListener)) continue;
                ((RecursingEventListener)((Object)componentArray[i])).addListenerToAllComponents(eventListener);
            }
        }

        @Override
        public void removeListenerFromAllComponents(EventListener eventListener) {
            Component[] componentArray = this.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                if (eventListener instanceof MouseMotionListener) {
                    componentArray[i].removeMouseMotionListener((MouseMotionListener)eventListener);
                }
                if (eventListener instanceof MouseListener) {
                    componentArray[i].removeMouseListener((MouseListener)eventListener);
                }
                if (!(componentArray[i] instanceof RecursingEventListener)) continue;
                ((RecursingEventListener)((Object)componentArray[i])).removeListenerFromAllComponents(eventListener);
            }
        }
    }
}

