/*
 * Decompiled with CFR 0.152.
 */
package norsys.netica;

import norsys.netica.NETICA;
import norsys.netica.NeticaException;
import norsys.netica.Util;

public class Environ {
    private static Environ defaultEnviron = null;
    public static final int NO_CHECK = 1;
    public static final int QUICK_CHECK = 2;
    public static final int REGULAR_CHECK = 3;
    public static final int COMPLETE_CHECK = 4;
    static final int QUERY_CHECK = -1;
    public static double UNDEF_DBL = 0.0;
    public static double INFINITY = 0.0;
    static final char QUERY_CHAR_ns = '\uffff';
    long envPtr;
    long currentErrorReportPtr;
    private static final String NORMAL_MESSAGE = "A-Okay";
    private int result = 0;
    private String mesg = "A-Okay";

    public Environ(String string) throws NeticaException {
        if (defaultEnviron != null && Environ.defaultEnviron.envPtr != 0L) {
            throw new NeticaException("An environment already exists that has not been closed with Environ.finalize().  With the current version of Netica, only one Environment can be active at once.  Close the existing Environ before constructing another.");
        }
        this.envPtr = NETICA.NewNeticaEnviron_bn(string);
        defaultEnviron = this;
        this.init();
        if (this.getVersion() != 221) {
            throw new NeticaException("Incorrect Netica library version.  Your Netica.dll or Netica.so file is incorrect for this version of Netica-J.");
        }
        Util.log("NETICA: created Environ.");
    }

    Environ() {
    }

    public static Environ getDefaultEnviron() {
        return defaultEnviron;
    }

    String init() throws NeticaException {
        this.testForValidEnvironment();
        String[] stringArray = new String[1];
        this.result = NETICA.InitNetica_bn(this.envPtr, stringArray);
        this.mesg = new String(stringArray[0]);
        if (this.result < 0) {
            throw new NeticaException(10000 - this.result, this.mesg);
        }
        INFINITY = NETICA.inf_dbl_func_ns();
        UNDEF_DBL = NETICA.undef_dbl_func_ns();
        this.testForError();
        return this.mesg;
    }

    public void finalize() throws NeticaException {
        this.testForValidEnvironment();
        if (this.envPtr == 0L) {
            return;
        }
        String[] stringArray = new String[1];
        this.result = NETICA.CloseNetica_bn(this.envPtr, stringArray);
        this.envPtr = 0L;
        this.currentErrorReportPtr = 0L;
    }

    synchronized void testForError() throws NeticaException {
        this.testForValidEnvironment();
        this.currentErrorReportPtr = NETICA.GetError_ns(this.envPtr, 5, 0L);
        if (this.currentErrorReportPtr != 0L) {
            NeticaException neticaException = new NeticaException(this.envPtr, this.currentErrorReportPtr);
            NETICA.ClearErrors_ns(this.envPtr, 5);
            throw neticaException;
        }
    }

    void clearErrors(int n) {
        if (this.envPtr == 0L) {
            return;
        }
        try {
            NETICA.ClearErrors_ns(this.envPtr, n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public int getVersion() throws NeticaException {
        this.testForValidEnvironment();
        String[] stringArray = new String[1];
        int n = NETICA.GetNeticaVersion_bn(this.envPtr, stringArray);
        this.testForError();
        return n + 6;
    }

    public String getVersionString() throws NeticaException {
        this.testForValidEnvironment();
        String[] stringArray = new String[1];
        NETICA.GetNeticaVersion_bn(this.envPtr, stringArray);
        this.testForError();
        StringBuffer stringBuffer = new StringBuffer();
        String string = stringArray[0];
        int n = string.indexOf("2.15");
        if (n > 0) {
            stringBuffer.append(string.substring(0, n));
        }
        stringBuffer.append("2.21");
        int n2 = string.indexOf("Netica");
        stringBuffer.append(string.substring(n + 4, n2));
        stringBuffer.append("Netica-J");
        stringBuffer.append(string.substring(n2 + 6));
        return stringBuffer.toString();
    }

    public int getArgumentChecking() throws NeticaException {
        this.testForValidEnvironment();
        int n = NETICA.ArgumentChecking_ns(-1, this.envPtr);
        this.testForError();
        return n;
    }

    public void setArgumentChecking(int n) throws NeticaException {
        this.testForValidEnvironment();
        NETICA.ArgumentChecking_ns(n, this.envPtr);
        this.testForError();
    }

    public double getMaxMemoryUsage() throws NeticaException {
        this.testForValidEnvironment();
        double d = NETICA.MaxMemoryUsage_ns(-1.0, this.envPtr);
        this.testForError();
        return d;
    }

    public void setMaxMemoryUsage(double d) throws NeticaException {
        this.testForValidEnvironment();
        NETICA.MaxMemoryUsage_ns(d, this.envPtr);
        this.testForError();
    }

    public char getCaseFileDelimChar() throws NeticaException {
        this.testForValidEnvironment();
        char c = NETICA.SetCaseFileDelimChar_ns('\uffff', this.envPtr);
        this.testForError();
        return c;
    }

    public void setCaseFileDelimChar(char c) throws NeticaException {
        this.testForValidEnvironment();
        NETICA.SetCaseFileDelimChar_ns(c, this.envPtr);
        this.testForError();
    }

    public char getMissingDataChar() throws NeticaException {
        this.testForValidEnvironment();
        char c = NETICA.SetMissingDataChar_ns('\uffff', this.envPtr);
        this.testForError();
        return c;
    }

    public void setMissingDataChar(char c) throws NeticaException {
        this.testForValidEnvironment();
        char c2 = NETICA.SetMissingDataChar_ns(c, this.envPtr);
        this.testForError();
    }

    private void testForValidEnvironment() throws NeticaException {
        if (this.envPtr == 0L) {
            throw new NeticaException(6005, "This environment has been closed down and can no longer be used.");
        }
    }
}

