/*
 * Decompiled with CFR 0.152.
 */
package norsys.netica.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Line2D;
import norsys.netica.NeticaException;
import norsys.netica.Node;
import norsys.netica.gui.DataDisplayer;
import norsys.netica.gui.NodePanel;

public class LinkGraphic
extends Component
implements DataDisplayer,
MouseListener {
    public static double LINK_CLICK_DISTANCE_TOLERANCE = 10.0;
    public static int LINK_DEFAULT_ARROW_HEAD_LENGTH = 8;
    public static int LINK_DEFAULT_ARROW_HEAD_WIDTH = 4;
    public static Stroke defaultStroke = new BasicStroke(1.0f);
    public static final int DISPLAY_MODE_GRAYED = 0;
    public static final int DISPLAY_MODE_NORMAL = 1;
    public static final int DISPLAY_MODE_HILITED = 2;
    public static Color defaultForegroundColor = Color.black;
    public static int defaultLineWidth = 1;
    public static Color grayedModeColor = Color.gray;
    public static Color hilitedModeColor = Color.red;
    Container parentContainer;
    NodePanel parentNodePanel;
    NodePanel childNodePanel;
    Node parentNode;
    Node childNode;
    Stroke stroke = defaultStroke;
    int displayMode = 1;
    int arrowHeadWidth = LINK_DEFAULT_ARROW_HEAD_WIDTH;
    int arrowHeadLength = LINK_DEFAULT_ARROW_HEAD_LENGTH;
    int x1;
    int y1;
    int x2;
    int y2;

    public LinkGraphic(Container container, NodePanel nodePanel, NodePanel nodePanel2) throws NeticaException {
        this.parentContainer = container;
        container.addMouseListener(this);
        this.setUp(nodePanel, nodePanel2);
        this.setForeground(defaultForegroundColor);
    }

    private void setUp(NodePanel nodePanel, NodePanel nodePanel2) throws NeticaException {
        this.childNodePanel = nodePanel;
        this.parentNodePanel = nodePanel2;
        this.computeGeometry();
    }

    private void computeGeometry() throws NeticaException {
        this.childNode = this.childNodePanel.getNode();
        this.parentNode = this.parentNodePanel.getNode();
        Point point = this.childNodePanel.getCenter();
        Point point2 = this.parentNodePanel.getCenter();
        Point point3 = LinkGraphic.edgePointInDirec(this.parentNodePanel, point, 1);
        Point point4 = LinkGraphic.edgePointInDirec(this.childNodePanel, point2, 1);
        this.setStartPoint(point3);
        this.setEndPoint(point4);
        if (this.parentNodePanel.getBounds().intersects(this.childNodePanel.getBounds())) {
            this.setVisible(false);
        }
    }

    public int getArrowHeadLength() {
        return this.arrowHeadLength;
    }

    public int getArrowHeadWidth() {
        return this.arrowHeadWidth;
    }

    public NodePanel getChildNodePanel() {
        return this.childNodePanel;
    }

    public Point getCenterPoint() {
        return new Point((this.x1 + this.x2) / 2, (this.y1 + this.y2) / 2);
    }

    public int getDisplayMode() {
        return this.displayMode;
    }

    public Point getEndPoint() {
        return new Point(this.x2, this.y2);
    }

    public NodePanel getParentNodePanel() {
        return this.parentNodePanel;
    }

    public Point getStartPoint() {
        return new Point(this.x1, this.y1);
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public boolean isNear(Point point) {
        return this.isWithinBounds(point) && this.getDistance(point) <= LINK_CLICK_DISTANCE_TOLERANCE;
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.stroke == null) {
            return;
        }
        int n = this.arrowHeadLength < 0 ? LINK_DEFAULT_ARROW_HEAD_LENGTH : this.arrowHeadLength;
        int n2 = this.arrowHeadWidth < 0 ? LINK_DEFAULT_ARROW_HEAD_WIDTH : this.arrowHeadWidth;
        int n3 = this.stroke instanceof BasicStroke ? Math.round(((BasicStroke)this.stroke).getLineWidth()) : 1;
        switch (this.getDisplayMode()) {
            case 0: {
                graphics.setColor(grayedModeColor);
                break;
            }
            case 2: {
                graphics.setColor(hilitedModeColor);
                break;
            }
            default: {
                graphics.setColor(this.getForeground());
            }
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(this.stroke);
        try {
            Point point = new Point(this.x2 - this.x1, this.y2 - this.y1);
            int n4 = Math.abs(point.x) + Math.abs(point.y);
            if (n4 != 0) {
                int n5 = Math.min(n2 + n3, n4 / 4);
                int n6 = Math.min(n + n3 * 4, n4 / 2);
                if (n5 == 0 || n6 == 0) {
                    graphics2D.drawLine(this.x1, this.y1, this.x2, this.y2);
                } else {
                    Point point2 = LinkGraphic.normvec1(point, n6);
                    Point point3 = new Point(this.x2 - point2.x, this.y2 - point2.y);
                    Point point4 = LinkGraphic.normvec1(new Point(-point.y, point.x), n5);
                    Point point5 = LinkGraphic.absc(LinkGraphic.normvec1(new Point(-point.y, point.x), n3 / 2));
                    graphics2D.drawLine(this.x1, this.y1, point3.x, point3.y);
                    point3.translate(point5.x, point5.y);
                    int[] nArray = new int[3];
                    int[] nArray2 = new int[3];
                    nArray[0] = point3.x + point4.x;
                    nArray[1] = point3.x - point4.x;
                    nArray[2] = this.x2 - point5.x;
                    nArray2[0] = point3.y + point4.y;
                    nArray2[1] = point3.y - point4.y;
                    nArray2[2] = this.y2 - point5.y;
                    graphics.fillPolygon(nArray, nArray2, 3);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        graphics2D.setStroke(stroke);
    }

    public void setArrowHeadLength(int n) {
        this.arrowHeadLength = n;
    }

    public void setArrowHeadWidth(int n) {
        this.arrowHeadWidth = n;
    }

    public void setDisplayMode(int n) {
        if (n != this.displayMode) {
            this.displayMode = n;
            if (this.isVisible()) {
                this.repaint();
            }
        }
    }

    public void setEndPoint(Point point) {
        this.x2 = point.x;
        this.y2 = point.y;
    }

    public void setStartPoint(Point point) {
        this.x1 = point.x;
        this.y1 = point.y;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("LinkGraphic: ");
        try {
            stringBuffer.append("[parent=");
            if (this.getParentNodePanel() == null || this.getParentNodePanel().getNode() == null) {
                stringBuffer.append("NULL");
            } else {
                stringBuffer.append(this.getParentNodePanel().getNode().getName());
            }
            stringBuffer.append(" at (").append(this.x1).append(",").append(this.y1).append("), child=");
            if (this.getChildNodePanel() == null || this.getChildNodePanel().getNode() == null) {
                stringBuffer.append("NULL");
            } else {
                stringBuffer.append(this.getChildNodePanel().getNode().getName());
            }
            stringBuffer.append(" at (").append(this.x2).append(",").append(this.y2).append(")]");
        }
        catch (NeticaException neticaException) {
            stringBuffer.append("? " + neticaException.getMessage());
        }
        return stringBuffer.toString();
    }

    static void drawArrow(Graphics graphics, Point point, Point point2, int n, int n2) {
        try {
            Point point3 = new Point(point2.x - point.x, point2.y - point.y);
            int n3 = Math.abs(point3.x) + Math.abs(point3.y);
            if (n3 != 0) {
                int n4 = 1;
                int n5 = Math.min(n2 + n4, n3 / 4);
                int n6 = Math.min(n + n4 * 4, n3 / 2);
                if (n5 == 0 || n6 == 0) {
                    graphics.drawLine(point.x, point.y, point2.x, point2.y);
                } else {
                    Point point4 = LinkGraphic.normvec1(point3, n6);
                    Point point5 = new Point(point2.x - point4.x, point2.y - point4.y);
                    Point point6 = LinkGraphic.normvec1(new Point(-point3.y, point3.x), n5);
                    Point point7 = LinkGraphic.absc(LinkGraphic.normvec1(new Point(-point3.y, point3.x), n4 / 2));
                    graphics.drawLine(point.x, point.y, point5.x, point5.y);
                    point5.translate(point7.x, point7.y);
                    int[] nArray = new int[3];
                    int[] nArray2 = new int[3];
                    nArray[0] = point5.x + point6.x;
                    nArray[1] = point5.x - point6.x;
                    nArray[2] = point2.x - point7.x;
                    nArray2[0] = point5.y + point6.y;
                    nArray2[1] = point5.y - point6.y;
                    nArray2[2] = point2.y - point7.y;
                    graphics.fillPolygon(nArray, nArray2, 3);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static Point edgePointInDirec(NodePanel nodePanel, Point point, int n) {
        int n2;
        n = 0;
        Point point2 = nodePanel.getCenter();
        Point point3 = new Point(point.x - point2.x, point.y - point2.y);
        if (point3.x == 0 && point3.y == 0) {
            return nodePanel.getCenter();
        }
        Point point4 = new Point();
        if (nodePanel.getStyle() == 2) {
            double d = Math.atan2(point3.y, point3.x);
            point4.x = point2.x + (int)(Math.cos(d) * (double)nodePanel.getWidth() / 2.0);
            point4.y = point2.y + (int)(Math.sin(d) * (double)nodePanel.getHeight() / 2.0);
            return point4;
        }
        int n3 = n2 = point3.y != 0 ? point3.x * (nodePanel.getHeight() / 2) / Math.abs(point3.y) : Integer.MAX_VALUE;
        if (Math.abs(n2) <= nodePanel.getWidth() / 2) {
            point4.x = n2 + point2.x;
            point4.y = point3.y > 0 ? nodePanel.getBounds().y + nodePanel.getBounds().height : nodePanel.getBounds().y - n;
        } else {
            if (point3.x == 0) {
                return point2;
            }
            point4.y = point2.y + point3.y * (nodePanel.getWidth() / 2) / Math.abs(point3.x);
            point4.x = point3.x > 0 ? nodePanel.getBounds().x + nodePanel.getBounds().width : nodePanel.getBounds().x - n;
        }
        return point4;
    }

    static Point normvec1(Point point, int n) throws Exception {
        int n2;
        if (point == null || point.x == 0 && point.y == 0) {
            throw new Exception("Invalid normvec1 input");
        }
        int n3 = Math.abs(point.x);
        long l = n3 > (n2 = Math.abs(point.y)) ? (n3 >> 2 > n2 ? (long)n3 : (long)(n3 + (n2 >> 1) - (n3 >> 3))) : (n2 >> 2 > n3 ? (long)n2 : (long)(n2 + (n3 >> 1) - (n2 >> 3)));
        Point point2 = new Point();
        point2.x = (int)((long)point.x * (long)n / l);
        point2.y = (int)((long)point.y * (long)n / l);
        return point2;
    }

    static Point absc(Point point) {
        return new Point(Math.abs(point.x), Math.abs(point.y));
    }

    double getDistance(Point point) {
        return Line2D.ptLineDist(this.x1, this.y1, this.x2, this.y2, point.x, point.y);
    }

    boolean isWithinBounds(Point point) {
        int n = point.x;
        int n2 = point.y;
        int n3 = (int)LINK_CLICK_DISTANCE_TOLERANCE;
        return (this.x1 < n + n3 && n < this.x2 + n3 || this.x1 > n - n3 && n > this.x2 - n3) && (this.y1 < n2 + n3 && n2 < this.y2 + n3 || this.y1 > n2 - n3 && n2 > this.y2 - n3);
    }

    @Override
    public void refreshDataDisplayed() throws NeticaException {
        this.setVisible(true);
        this.computeGeometry();
        this.repaint();
    }

    void informMouseListeners(int n, MouseEvent mouseEvent) {
        MouseListener[] mouseListenerArray = this.getMouseListeners();
        mouseEvent.setSource(this);
        block5: for (int i = 0; i < mouseListenerArray.length; ++i) {
            if (mouseListenerArray[i] == this.parentContainer) continue;
            switch (n) {
                case 500: {
                    mouseListenerArray[i].mouseClicked(mouseEvent);
                    continue block5;
                }
                case 501: {
                    mouseListenerArray[i].mousePressed(mouseEvent);
                    continue block5;
                }
                case 502: {
                    mouseListenerArray[i].mouseReleased(mouseEvent);
                }
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.isEnabled() && this.isNear(mouseEvent.getPoint())) {
            this.informMouseListeners(500, mouseEvent);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.isEnabled() && this.isNear(mouseEvent.getPoint())) {
            this.informMouseListeners(501, mouseEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.isEnabled() && this.isNear(mouseEvent.getPoint())) {
            this.informMouseListeners(502, mouseEvent);
        }
    }
}

