/*
 * Decompiled with CFR 0.152.
 */
package norsys.netica;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import norsys.netica.Environ;
import norsys.netica.NETICA;
import norsys.netica.Net;
import norsys.netica.NeticaEvent;
import norsys.netica.NeticaException;
import norsys.netica.NeticaListener;
import norsys.netica.Node;
import norsys.netica.State;
import norsys.netica.User;
import norsys.netica.Util;

public abstract class Generic
implements NeticaListener {
    public static final int NAME_MAX = 30;
    static final int NO_TYPE = 0;
    static final int NET_TYPE = 1;
    static final int NODE_TYPE = 2;
    static final int STATE_TYPE = 3;
    static final String[] typeName = new String[]{"noType", "Net", "Node", "State"};
    int parentType = 0;
    Environ parentEnv;
    private Hashtable listeners = new Hashtable();
    private User userObj;

    Generic() throws NeticaException {
        if (this instanceof Net) {
            this.parentType = 1;
        } else if (this instanceof Node) {
            this.parentType = 2;
        } else if (this instanceof State) {
            this.parentType = 3;
        }
    }

    long getPtr() throws NeticaException {
        switch (this.parentType) {
            case 1: {
                return ((Net)this).netPtr;
            }
            case 2: {
                return ((Node)this).nodePtr;
            }
            case 3: {
                return ((State)this).parent.nodePtr;
            }
        }
        return 0L;
    }

    private int getStateIndex() {
        return ((State)this).stateIndex;
    }

    public Environ getEnviron() throws NeticaException {
        this.parentEnv.testForError();
        return this.parentEnv;
    }

    public String getName() throws NeticaException {
        String string = null;
        switch (this.parentType) {
            case 1: {
                string = NETICA.GetNetName_bn(this.getPtr());
                break;
            }
            case 2: {
                string = NETICA.GetNodeName_bn(this.getPtr());
                break;
            }
            case 3: {
                string = NETICA.GetNodeStateName_bn(this.getPtr(), this.getStateIndex());
                if (string != null && !string.equals("")) break;
                string = "s" + this.getStateIndex();
            }
        }
        this.parentEnv.testForError();
        return string;
    }

    public void setName(String string) throws NeticaException {
        switch (this.parentType) {
            case 1: {
                NETICA.SetNetName_bn(this.getPtr(), string);
                break;
            }
            case 2: {
                NETICA.SetNodeName_bn(this.getPtr(), string);
                break;
            }
            case 3: {
                NETICA.SetNodeStateName_bn(this.getPtr(), this.getStateIndex(), string);
            }
        }
        this.parentEnv.testForError();
    }

    public String getTitle() throws NeticaException {
        String string = null;
        switch (this.parentType) {
            case 1: {
                string = NETICA.GetNetTitle_bn(this.getPtr());
                break;
            }
            case 2: {
                string = NETICA.GetNodeTitle_bn(this.getPtr());
                break;
            }
            case 3: {
                string = NETICA.GetNodeStateTitle_bn(this.getPtr(), this.getStateIndex());
            }
        }
        this.parentEnv.testForError();
        return string;
    }

    public void setTitle(String string) throws NeticaException {
        switch (this.parentType) {
            case 1: {
                NETICA.SetNetTitle_bn(this.getPtr(), string);
                break;
            }
            case 2: {
                NETICA.SetNodeTitle_bn(this.getPtr(), string);
                break;
            }
            case 3: {
                NETICA.SetNodeStateTitle_bn(this.getPtr(), this.getStateIndex(), string);
            }
        }
        this.parentEnv.testForError();
    }

    public String getComment() throws NeticaException {
        String string = null;
        switch (this.parentType) {
            case 1: {
                string = NETICA.GetNetComment_bn(this.getPtr());
                break;
            }
            case 2: {
                string = NETICA.GetNodeComment_bn(this.getPtr());
                break;
            }
            case 3: {
                throw new NeticaException("unsupported Generic feature for states");
            }
        }
        this.parentEnv.testForError();
        return string;
    }

    public void setComment(String string) throws NeticaException {
        switch (this.parentType) {
            case 1: {
                NETICA.SetNetComment_bn(this.getPtr(), string);
                break;
            }
            case 2: {
                NETICA.SetNodeComment_bn(this.getPtr(), string);
                break;
            }
            case 3: {
                throw new NeticaException("unsupported Generic feature for states");
            }
        }
        this.parentEnv.testForError();
    }

    String getIcon() throws NeticaException {
        String string = null;
        switch (this.parentType) {
            case 1: {
                string = NETICA.GetNetIcon_bn(this.getPtr());
                break;
            }
            case 2: {
                string = NETICA.GetNodeIcon_bn(this.getPtr());
                break;
            }
            case 3: {
                throw new NeticaException("unsupported Generic feature for states");
            }
        }
        this.parentEnv.testForError();
        return string;
    }

    void setIcon(String string) throws NeticaException {
        switch (this.parentType) {
            case 1: {
                NETICA.SetNetIcon_bn(this.getPtr(), string);
                break;
            }
            case 2: {
                NETICA.SetNodeIcon_bn(this.getPtr(), string);
                break;
            }
            case 3: {
                throw new NeticaException("unsupported Generic feature for states");
            }
        }
        this.parentEnv.testForError();
    }

    public User user() throws NeticaException {
        if (this.parentType == 3) {
            throw new NeticaException("State objects do not currently support User objects.");
        }
        if (this.userObj == null) {
            this.userObj = new User(this);
        }
        return this.userObj;
    }

    public Object getUserData() throws NeticaException {
        return this.user().getReference();
    }

    public void setUserData(Object object) throws NeticaException {
        this.user().setReference(object);
    }

    public Object getUserField(String string) throws NeticaException {
        return this.user().getObject(string);
    }

    public void setUserField(String string, Serializable serializable) throws NeticaException {
        this.user().setObject(string, serializable);
    }

    public void getNthUserField(int n, String[] stringArray, Object[] objectArray) throws NeticaException {
        if (stringArray == null || stringArray.length < 1) {
            throw new NeticaException("Parameter name[] to Generic.getNthUserField() is null or of zero length.");
        }
        int[] nArray = new int[1];
        switch (this.parentType) {
            case 1: {
                NETICA.GetNetNthUserField_bn(this.getPtr(), n, stringArray, objectArray, nArray, 0);
                break;
            }
            case 2: {
                NETICA.GetNodeNthUserField_bn(this.getPtr(), n, stringArray, objectArray, nArray, 0);
                break;
            }
            case 3: {
                throw new NeticaException("unsupported Generic feature for states");
            }
        }
        this.parentEnv.testForError();
        if (nArray[0] == -1 || stringArray == null || stringArray[0] == null) {
            stringArray[0] = "";
            if (objectArray != null && objectArray.length > 0) {
                objectArray[0] = "";
            }
            return;
        }
        if (objectArray != null && objectArray.length > 0 && objectArray[0] != null) {
            byte[] byArray = (byte[])objectArray[0];
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            try {
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                objectArray[0] = objectInputStream.readObject();
            }
            catch (IOException iOException) {
                try {
                    objectArray[0] = new String(byArray, "UTF-8");
                }
                catch (Exception exception) {
                    throw new NeticaException("Generic.getNthUserField: IOException reading ObjectInputStream");
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NeticaException("Generic.getNthUserField: ClassNotFoundException reading ObjectInputStream");
            }
        }
    }

    public void eventOccurred(NeticaEvent neticaEvent) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            NeticaListener neticaListener = (NeticaListener)enumeration.nextElement();
            neticaListener.eventOccurred(neticaEvent);
        }
        Util.log("*** " + typeName[this.parentType] + ".eventOccurred() was called with event.id = " + neticaEvent.getId());
        try {
            block1 : switch (neticaEvent.getId()) {
                case 4: {
                    Util.log(" DELETE_EVENT received by " + typeName[this.parentType] + ": " + this.getName());
                    switch (this.parentType) {
                        case 1: {
                            ((Net)this).onDeleteCallback(neticaEvent);
                            break block1;
                        }
                        case 2: {
                            ((Node)this).onDeleteCallback(neticaEvent);
                            break block1;
                        }
                        case 3: {
                            return;
                        }
                    }
                    break;
                }
            }
        }
        catch (Exception exception) {
            System.err.println("********************************************************* ");
            System.err.println("**  Netica-J Internal Error in Generic.eventOccurred() ** ");
            System.err.println("**  Please inform Norsys by e-mailing info@norsys.com  ** ");
            System.err.println("**  this instanceof " + this.getClass().getName() + " ** ");
            System.err.println("**  typeName[parentType] = " + typeName[this.parentType] + " ** ");
            System.err.println("********************************************************* ");
            exception.printStackTrace();
        }
    }

    public void addListener(NeticaListener neticaListener) throws NeticaException {
        this.listeners.put(neticaListener, neticaListener);
    }

    public void removeListener(NeticaListener neticaListener) throws NeticaException {
        if (this.parentType == 3) {
            throw new NeticaException("unsupported Generic feature for States");
        }
        NeticaListener neticaListener2 = (NeticaListener)this.listeners.get(neticaListener);
        if (neticaListener2 == null) {
            throw new NeticaException("The object supplied is not on record as a current listener; you must call addListener() with a Listener object before calling removeListener() on the same object.");
        }
        this.listeners.remove(neticaListener);
    }

    public String toString() {
        try {
            return this.getName();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

