/*
 * Decompiled with CFR 0.152.
 */
package norsys.netica;

import norsys.netica.Generic;
import norsys.netica.NeticaException;
import norsys.netica.Node;

public class State
extends Generic {
    Node parent;
    int stateIndex = -1;

    State(Node node, int n) throws NeticaException {
        this.stateIndex = n;
        this.parent = node;
        this.parentEnv = node.parentEnv;
    }

    public int getIndex() {
        return this.stateIndex;
    }

    public Node getNode() {
        return this.parent;
    }

    public double getNumeric() throws NeticaException {
        double[] dArray = this.getNode().getLevels();
        if (dArray == null) {
            throw new NeticaException("Levels have not yet been assigned to this discrete state.  Call setNumeric() or Node.setLevels() first.");
        }
        return dArray[this.stateIndex];
    }

    public void setNumeric(double d) throws NeticaException {
        if (this.getNode().getType() == 101) {
            throw new NeticaException("Node.setNumeric() can only be called on discrete nodes (i.e., where node.getType() == Node.DISCRETE_TYPE).");
        }
        double[] dArray = this.getNode().getLevels();
        if (dArray == null) {
            dArray = new double[this.getNode().getNumStates()];
        }
        dArray[this.stateIndex] = d;
        this.getNode().setLevels(dArray);
    }
}

