# -*- coding: utf-8 -*-
"""
Created on Sat Jan 13 18:06:54 2018

@author: Sophie
"""
import sys, os
sys.path.append(os.path.abspath('..\\src'))
import neticapy

env = neticapy.Environ()	
res, mesg = env.init_netica()
print(mesg)
if res < 0:
    raise SystemExit
    
net = env.new_file_stream("Data Files\\ChestClinic.dne").read_net(neticapy.ReadingOption.NO_VISUAL_INFO)

test_nodes = net.new_node_list(0)
unobsv_nodes = net.new_node_list(0)

VisitAsia = net.get_node_named("VisitAsia")
Tuberculosis = net.get_node_named("Tuberculosis")
Cancer = net.get_node_named("Cancer")
Smoking = net.get_node_named("Smoking")
TbOrCa = net.get_node_named("TbOrCa")
XRay = net.get_node_named("XRay")
Dyspnea = net.get_node_named("Dyspnea")
Bronchitis = net.get_node_named("Bronchitis")

# The observed nodes are the factors known during diagnosis:
test_nodes.add(Cancer, None)

# The unobserved nodes are the factors not known during diagnosis:
unobsv_nodes.add(Bronchitis, None)
unobsv_nodes.add(Tuberculosis, None)
unobsv_nodes.add(TbOrCa, None)

net.retract_findings()      # IMPORTANT: Otherwise any findings will be part of tests !!

net.compile_()    

tester = net.new_tester(test_nodes, unobsv_nodes, -1)

casefile = env.new_file_stream("Data Files\\ChestClinic.cas")

caseset = env.new_caseset("ChestClinicCases")

caseset.add_file(casefile, 1)
tester.test_with_cases(caseset)

#print("\nGiven an abnormal X-ray, \n\        the probability of tuberculosis is %.6f" % )

#print("Error rate for %s = %g %%\n\n", Cancer.title, 
#		tester.error_rate(Cancer) * 100.0)

tester.print_confusion_matrix(Cancer)

print("\nError rate for {} = {}%\n".format(Cancer.name, 
      (tester.error_rate(Cancer) * 100.0)))

print("Logarithmic loss for {} = {}\n".format(Cancer.name, 
      tester.log_loss(Cancer)))

	
caseset.delete()
casefile.delete()
tester.delete()
test_nodes.delete()
unobsv_nodes.delete()
net.delete()
res, mesg = env.close_netica()
print(mesg)

