/* 
 *   DoInference.c
 *
 * Example software using the Netica-C API to read from file the classic 
 * Bayes net 'ChestClinic.dne' that was created by the BuildNet.c example,
 * enter various findings (evidence), and perform probabilistic inference.
 *
 * Copyright (C) 1992-2018 by Norsys Software Corp.
 * The software in this file may be copied, modified, and/or included in 
 * derivative works without charge or obligation.
 * This file contains example software only, and Norsys makes no warranty that 
 * it is suitable for any particular purpose, or without defects.
 */

#include <stdio.h>
#include <stdlib.h>
#include "Netica.h"
#include "NeticaEx.h"

#ifndef WDIR
#define WDIR "Data Files/"
#endif

environ_ns* env;


int main (void){
	net_bn* net = NULL;
	double belief;
	char mesg[MESG_LEN_ns];
	int res;
	
	env = NewNeticaEnviron_ns (NULL, NULL, NULL);
	res = InitNetica2_bn (env, mesg);
	printf ("%s\n", mesg);
	if (res < 0)  return -1;
	
	net = ReadNet_bn (NewFileStream_ns (WDIR"ChestClinic.dne", env, NULL), NO_VISUAL_INFO);
	CHK_ERR

	CompileNet_bn (net);

	belief = GetNodeBelief ("Tuberculosis", "present", net);
	CHK_ERR

	printf ("The probability of tuberculosis is %g\n\n", belief);

	EnterFinding ("XRay", "abnormal", net);
	belief = GetNodeBelief ("Tuberculosis", "present", net);
	CHK_ERR

	printf ("Given an abnormal X-ray, \n\
             the probability of tuberculosis is %g\n\n", belief);

	EnterFinding ("VisitAsia", "visit", net);
	belief = GetNodeBelief ("Tuberculosis", "present", net);
	CHK_ERR

	printf ("Given an abnormal X-ray and a visit to Asia, \n\
	         the probability of tuberculosis is %g\n\n", belief);

	DeleteNet_bn (net);
	res = CloseNetica_bn (env, mesg);

	printf ("%s\n", mesg);
	printf ("Press <enter> key to quit\n");
	getchar();
	return (res < 0 ? -3 : 0);
}
