/* 
 *   SimulateCases.c
 *
 * Example use of Netica-C API to generate random cases that follow
 * the probability distribution given by a Bayes net.
 *
 * Copyright (C) 1992-2018 by Norsys Software Corp.
 * The software in this file may be copied, modified, and/or included in 
 * derivative works without charge or obligation.
 * This file contains example software only, and Norsys makes no warranty that 
 * it is suitable for any particular purpose, or without defects.
 */

#include <stdio.h>
#include <stdlib.h>
#include "Netica.h"
#include "NeticaEx.h"

#ifndef WDIR
#define WDIR "Data Files/"
#endif

environ_ns* env;


int main (void){
	net_bn *orig_net = NULL;
	const nodelist_bn* orig_nodes;
	const int numcases = 200;
	stream_ns* casefile = NULL;
	char mesg[MESG_LEN_ns];
	int i, res;

	env = NewNeticaEnviron_ns (NULL, NULL, NULL);
	res = InitNetica2_bn (env, mesg);
	printf ("%s\n", mesg);
	if (res < 0)  return -1;
	
	// Read in the net created by the BuildNet.c example program
	orig_net = ReadNet_bn (NewFileStream_ns (WDIR"ChestClinic.dne", env, NULL), NO_VISUAL_INFO);
	orig_nodes = GetNetNodes2_bn (orig_net, NULL);
	SetNetAutoUpdate_bn (orig_net, 0);
	CHK_ERR

	remove (WDIR"ChestClinic.cas");
	casefile =  NewFileStream_ns (WDIR"ChestClinic.cas", env, NULL);
	for (i = 0;  i < numcases;  ++i){
		RetractNetFindings_bn (orig_net);
		res= GenerateRandomCase_bn (orig_nodes, DEFAULT_SAMPLING, 20, NULL);
		if (res >= 0)
			WriteNetFindings_bn (orig_nodes, casefile, i, -1);
		CHK_ERR
	}
	
	printf ("\nCreated file '%sChestClinic.cas' with simulation results.\n", WDIR);

	DeleteStream_ns (casefile);
	DeleteNet_bn (orig_net);
	res= CloseNetica_bn (env, mesg);
	printf ("%s\n", mesg);
	printf ("Press <enter> key to quit\n", mesg);
	getchar();
	return (res < 0 ? -3 : 0);
}
