/* 
 * NeticaExCPP.h
 *
 * Header file for C++ Development with Netica API, version 4.15 and later.
 *
 * This file is under development.
 * Please send any suggestions, or reports of problems, to:  support@norsys.com
 *
 * See file Netica.h for the C interface to Netica API.
 * For more information, see www.norsys.com
 *
 * Copyright 2000-2011 by Norsys Software Corp.  All rights reserved.
 *
 */

#ifndef __NETICAEX_CPP_H
#define __NETICAEX_CPP_H

#include "NeticaCPP.h"

using namespace netica;

class Environment1 : public Environ {
public:
	Environment1 (bool primitive, const char license[], Environ* env = 0, const char locn[] = 0):
		Environ (primitive, license, env, locn){
		}
	Environment1 (const char license[], Environ* env = 0, const char locn[] = 0):
		Environ (license, env, locn){
		}
	void            ClearErrors1 (errseverity_ns severity);
	};


class Streamer1 : public Streamer {
public:
	Streamer1 (const char filename[], const Environ& env = *GetEnviron(), const char access[] = 0):
		Streamer (filename, env, access){
		}
	Streamer1 (const Environ& env = *GetEnviron(), const char name[] = 0, const char access[] = 0):
		Streamer (env, name, access){
		}
	long            CountCases ();
	};


class Node1 : public Node {
public:
	Node1 (const char name[], int num_states, Net& net):
		Node (name, num_states, net){
		}
	Node1 (const char name[], const char state_names[], Net& net):
		Node (name, state_names, net){
		}
	void			SetStates (int num_states, ...);
	void            MakeProbsUniform ();
	void            DeleteLinks (Node* parent);
	bool            isLinkDisconnected (int link_index) const;
	void            SetNodeFinding (int state);
	Node*           Duplicate () const;
	Node*           Duplicate (Net* new_net) const;
	void            AbsorbNode ();
	};


class NodeList1 : public NodeList {
public:
	NodeList1 (Net& net, int length = 0):
		NodeList (net, length){
		}
	NodeList1 (const NodeList& list):
		NodeList (list){
		}
	double			SizeCartesianProduct () const;
	Node*			FormCliqueWith () const;
	void            DeleteNodes ();
	bool            NextStates (state_bn states[]) const;
	NodeList1*      TransferNodes (Net* new_net);
	void            FadeCPTables (double degree) const;
	void            RemoveNode (Node* node);
	void            erase_fast (int index);
	NodeList1*      DisconnectGroup ();
	};


class Net1 : public Net {
public:
	Net1 (const char name[], const Environ& env):
		Net (name, env){
		}
	Net1 (const Net& net, const char new_name[] = 0, const Environ* env = 0, const char options[] = 0):
		Net (net, new_name, env, options){
		}
	Net1 (Streamer& stream, int control = 0):
		Net (stream, control){
		}
	};

#endif // __NETICAEX_CPP_H
