//
//  File.c
//  NeticaIOSDemo
//
//  Created on 2012-10-05.
//  Copyright (c) 2012 Norsys Software Corp. All rights reserved.
//

#include <stdio.h>
#include <stdlib.h>
#include "myLib.h"
#include "Netica.h"
#include "NeticaEx.h"




char* externalFunc( const char* docDir ){
    
  printf ("DocDir=%s\n", docDir);

  return runDemo( docDir );

}


#define CHKERR  {if (GetError_ns (env, ERROR_ERR, NULL))  goto error;}

// caller is reponsible for freeing the char* returned
char* runDemo (const char* docDir ){
  environ_ns *env;
  net_bn *net;
  double belief;
  char mesg[MESG_LEN_ns];
  char* buf = (char*) malloc( (size_t) 2000 );
  int index = 0;
  int res;
#if USING_SIMULATOR
  char* filePath = "/Users/mroman/ChestClinic.dne"; //for convenience, since IOS Simulator can access entire filesystem
#else
  //-- if a real IOS device, upload ChestClinic.dne to app's Documents/  directory
  char* filePath = (char*) malloc( (size_t) ((strlen(docDir)) + 100) );
  strcpy( filePath, docDir );
  strcat( filePath, "/ChestClinic.dne" );
#endif
    
  
  index += sprintf ( &buf[index], "Welcome to Netica API!\n");
  index += sprintf ( &buf[index], "This demo project is based on examples_c/DoInference.c\n");
  index += sprintf ( &buf[index], "------------------------------------------------------\n\n");

  
  env = NewNeticaEnviron_ns (NULL, NULL, NULL);
  res = InitNetica2_bn (env, mesg);
    
  index += sprintf ( &buf[index], "%s\n", mesg);
  if (res < 0)  return buf;
  
  net = ReadNet_bn ( NewFileStream_ns ( filePath, env, NULL), NO_VISUAL_INFO); 
  CHKERR
  CompileNet_bn (net);
    
  belief = GetNodeBelief ("Tuberculosis", "present", net);
  CHKERR
    
  index += sprintf ( &buf[index], "The probability of tuberculosis is %g\n\n", belief);
    
  EnterFinding ("XRay", "abnormal", net);
  belief = GetNodeBelief ("Tuberculosis", "present", net);
  CHKERR
    
  index += sprintf ( &buf[index], "Given an abnormal X-ray,\nthe probability of tuberculosis is %g\n\n", belief);
    
  EnterFinding ("VisitAsia", "visit", net);
  belief = GetNodeBelief ("Tuberculosis", "present", net);
  CHKERR
    
  index += sprintf ( &buf[index], "Given an abnormal X-ray and a visit to Asia,\nthe probability of tuberculosis is %g\n\n", belief);
    
 end:
    DeleteNet_bn (net);
    res = CloseNetica_bn (env, mesg);
    return buf;
 error:
    index += sprintf ( &buf[index], "NeticaDemo: Error in %s\n",
    ErrorMessage_ns (GetError_ns (env, ERROR_ERR, NULL)));
    goto end;
}
