//
//  ViewController.m
//  NeticaIOSDemo
//
//  Created on 2012-10-05.
//  Copyright (c) 2012 Norsys, Software, Corp. All rights reserved.
//

#import "ViewController.h"
#include "MyLib.h"

@interface ViewController ()
@property (weak, nonatomic) IBOutlet UITextView *myTextView;

@end

@implementation ViewController


- (IBAction)myButtonActionHandler:(id)sender {
    
  NSArray *paths = NSSearchPathForDirectoriesInDomains(
						       NSDocumentDirectory,
						       NSUserDomainMask, YES);
  NSString* docDir = [paths objectAtIndex:0];
   
#if ! USING_SIMULATOR
[self setupNeticaTestDirectory];  
#endif
    
  NSLog ( @"The current docDir: %@", docDir );
    
  const char* docDirString = [docDir UTF8String];
    
  char* reslt = externalFunc( docDirString );
 
  NSString* result = [NSString stringWithFormat:@"%s" , reslt];
  self.myTextView.text = result;
    
}

/*
 * This is just an example of the sort of thing you may wish to do.  The following takes a directory called "test/" which was
 * previously uploaded to the root of the app sandbox, and copies it into the Documents/ directory, where it can edited.
 * For purposes of running this demonstration, ChestClinic.dne is assumed to be in the test/ directory.
 */
- (void) setupNeticaTestDirectory {
    
    NSString *documentsDirectory = [NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES) objectAtIndex:0];
    NSString *sourcePath = [documentsDirectory stringByAppendingPathComponent:@"../test"];
    NSString *sinkPath   = [documentsDirectory stringByAppendingPathComponent:@"test"];
    //NSString *sinkPath = [[[NSBundle mainBundle] resourcePath] stringByAppendingPathComponent:@"test"];
    
    NSLog(@" Documents Path: %@\n SourcePath: %@ \n Sink Path: %@", documentsDirectory, sourcePath, sinkPath);
    
    NSError *error = nil;
    NSFileManager* fileManager = [NSFileManager defaultManager];
    
    //[[NSFileManager defaultManager] createDirectoryAtPath: sinkPath
    //                                withIntermediateDirectories:YES
    //                                           attributes:nil
    //                                                error:&error];
    
    if ([ fileManager fileExistsAtPath:sinkPath])
    {
        //remove destination, so soucer may be copied
        if (![fileManager removeItemAtPath:sinkPath error:&error])
        {
            NSLog(@"Could not remove old files. Error:%@",error);
            //[error release];
        }
    }
    error = nil;
    
    if (!error) {
        [[NSFileManager defaultManager] copyItemAtPath:sourcePath
                                                toPath:sinkPath
                                                 error:&error];
    }
    
    
    if (error) {
        NSLog(@"Error description-%@ \n", [error localizedDescription]);
        NSLog(@"Error reason-%@", [error localizedFailureReason]);
    }
     
}


- (void)viewDidLoad
{
  [super viewDidLoad];
  // Do any additional setup after loading the view, typically from a nib.
}

- (void)didReceiveMemoryWarning
{
  [super didReceiveMemoryWarning];
  // Dispose of any resources that can be recreated.
}

- (void)viewDidUnload {
  [self setMyTextView:nil];
  [super viewDidUnload];
}
@end
