/*
 * Decompiled with CFR 0.152.
 */
package norsys.netica;

import norsys.netica.Environ;
import norsys.netica.NETICA;
import norsys.netica.Net;
import norsys.netica.NeticaException;
import norsys.netica.NodeList;

public class DatabaseManager {
    Environ parentEnv;
    long dbmgrPtr;

    public DatabaseManager(String string, String string2, Environ environ) throws NeticaException {
        if (environ == null) {
            environ = Environ.getDefaultEnviron();
        }
        this.parentEnv = environ;
        this.dbmgrPtr = NETICA.NewDBManager_cs(string, string2, environ.envPtr);
        environ.testForError();
        if (this.dbmgrPtr == 0L) {
            throw new NeticaException("Connection failed to ODBC Server: " + string + ";  ODBC service may be unavailable, or username/password may be incorrect.");
        }
    }

    public void addNodes(Net net, String string, String string2, String string3, String string4) throws NeticaException {
        NETICA.AddNodesFromDB_bn(this.dbmgrPtr, net.netPtr, string, string2, string3, string4);
        this.parentEnv.testForError();
    }

    public void executeSql(String string, String string2) throws NeticaException {
        NETICA.ExecuteDBSql_cs(this.dbmgrPtr, string, string2);
        this.parentEnv.testForError();
    }

    public void finalize() throws NeticaException {
        if (this.dbmgrPtr == 0L) {
            return;
        }
        NETICA.DeleteDBManager_cs(this.dbmgrPtr);
        this.parentEnv.testForError();
        this.dbmgrPtr = 0L;
    }

    public Environ getEnviron() throws NeticaException {
        return this.parentEnv;
    }

    public void insertFindings(NodeList nodeList, String string, String string2, String string3) throws NeticaException {
        long l = nodeList.getNodeListPtr();
        NETICA.InsertFindingsIntoDB_bn(this.dbmgrPtr, l, string, string2, string3);
        this.parentEnv.testForError();
    }
}

