/*
 * Decompiled with CFR 0.152.
 */
package norsys.netica;

import java.io.IOException;
import norsys.netica.DatabaseManager;
import norsys.netica.Environ;
import norsys.netica.NETICA;
import norsys.netica.NeticaException;
import norsys.netica.NodeList;
import norsys.netica.Streamer;

public class Caseset {
    Environ parentEnv;
    long casesetPtr = 0L;
    Streamer myInStream;

    public Caseset() throws NeticaException {
        this(null, Environ.getDefaultEnviron());
    }

    public Caseset(String string, Environ environ) throws NeticaException {
        this.parentEnv = environ;
        this.casesetPtr = NETICA.NewCaseset_cs(string, this.parentEnv.envPtr);
        this.parentEnv.testForError();
    }

    Caseset(long l, Environ environ) {
        this.casesetPtr = l;
        this.parentEnv = environ;
    }

    public void addCases(Streamer streamer, double d, String string) throws NeticaException {
        NETICA.AddFileToCaseset_cs(streamer.streamPtr, this.casesetPtr, d, string);
        this.myInStream = streamer;
        this.parentEnv.testForError();
    }

    public void addCases(DatabaseManager databaseManager, double d, NodeList nodeList, String string, String string2, String string3, String string4) throws NeticaException {
        NETICA.AddDBCasesToCaseset_cs(this.casesetPtr, databaseManager.dbmgrPtr, d, nodeList.getNodeListPtr(), string, string2, string3, string4);
        this.parentEnv.testForError();
    }

    public void finalize() throws NeticaException {
        if (this.casesetPtr == 0L) {
            if (Environ.isAndroid) {
                return;
            }
            throw new NeticaException(6005, "Caseset.finalize(): Object has already been deleted.");
        }
        NETICA.DeleteCaseset_cs(this.casesetPtr);
        this.parentEnv.testForError();
        this.casesetPtr = 0L;
        this.myInStream = null;
    }

    public Environ getEnviron() {
        return this.parentEnv;
    }

    public void writeCases(Streamer streamer, String string) throws NeticaException {
        NETICA.WriteCaseset_cs(this.casesetPtr, streamer.streamPtr, string);
        this.parentEnv.testForError();
        if (streamer.outputStream != null) {
            byte[] byArray = NETICA.GetStreamContents_ns(streamer.streamPtr);
            System.out.println("[[[[[[" + new String(byArray) + "]]]]]]]");
            this.parentEnv.testForError();
            try {
                streamer.outputStream.write(byArray);
            }
            catch (IOException iOException) {
                throw new NeticaException("Streamer(OutputStream, Environ): IOException writing OutputStream");
            }
        }
    }

    long getCasesetPtr() {
        return this.casesetPtr;
    }
}

