/*
 * Decompiled with CFR 0.152.
 */
package norsys.netica;

import norsys.netica.Environ;
import norsys.netica.NETICA;
import norsys.netica.NeticaException;
import norsys.netica.Node;
import norsys.netica.NodeList;

public class Sensitivity {
    public static final int ENTROPY_SENSV = 2;
    public static final int REAL_SENSV = 4;
    public static final int VARIANCE_SENSV = 256;
    public static final int VARIANCE_OF_REAL_SENSV = 260;
    long sensitivityPtr;
    Environ parentEnv;

    public Sensitivity(Node node, NodeList nodeList, int n) throws NeticaException {
        this.parentEnv = node.parentEnv;
        this.sensitivityPtr = NETICA.NewSensvToFinding_bn(node.nodePtr, nodeList.getNodeListPtr(), n);
        this.parentEnv.testForError();
    }

    public void finalize() throws NeticaException {
        if (this.sensitivityPtr == 0L) {
            return;
        }
        NETICA.DeleteSensvToFinding_bn(this.sensitivityPtr);
        this.parentEnv.testForError();
        this.sensitivityPtr = 0L;
    }

    public double getMutualInfo(Node node) throws NeticaException {
        if (this.sensitivityPtr == 0L) {
            throw new NeticaException(" sensitivityPtr == 0!!!!");
        }
        double d = NETICA.GetMutualInfo_bn(this.sensitivityPtr, node.nodePtr);
        this.parentEnv.testForError();
        return d;
    }

    public double getVarianceOfReal(Node node) throws NeticaException {
        double d = NETICA.GetVarianceOfReal_bn(this.sensitivityPtr, node.nodePtr);
        this.parentEnv.testForError();
        return d;
    }
}

