/*
 * Decompiled with CFR 0.152.
 */
package norsys.netica.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.border.Border;
import norsys.netica.Node;
import norsys.netica.gui.NodePanel;

public class NodePanel_LabeledBox
extends NodePanel {
    public static Color defaultBackgroundColor = null;
    public static Color defaultForegroundColor = NodePanel.defaultForegroundColor;
    public static Color defaultBorderColor = NodePanel.defaultBorderColor;
    public static Font defaultFont = NodePanel.defaultTitleFont;
    public static Border defaultBorder = NodePanel.defaultTitleBorder;
    public static int defaultRoundedCornerArcWidth = 20;
    public static int defaultRoundedCornerArcHeight = 20;
    public static int minWidth = 50;
    public static int maxWidth = 500;
    Color borderColor = defaultBorderColor;

    public NodePanel_LabeledBox(Node node) throws Exception {
        super(node);
        this.style = 1;
        this.setupPanel();
    }

    @Override
    protected void setupPanel() throws Exception {
        super.setupPanel();
        if (defaultBackgroundColor != null) {
            this.setBackground(defaultBackgroundColor);
        }
        this.setLayout(new BorderLayout());
        String string = this.parentNode.getTitle();
        if (string.equals("")) {
            string = this.parentNode.getName();
        }
        this.nodeTitleJLabel = new JLabel(string, 0);
        this.nodeTitleJLabel.setBackground(defaultBackgroundColor);
        this.nodeTitleJLabel.setForeground(defaultForegroundColor);
        this.nodeTitleJLabel.setFont(defaultTitleFont);
        if (this.nodeKind == 204) {
            int n = this.getHeight() / 2;
            Border border = BorderFactory.createEmptyBorder(2, 8 + n, 2, 8 + n);
            this.nodeTitleJLabel.setBorder(border);
        } else {
            this.nodeTitleJLabel.setBorder(defaultBorder);
        }
        this.add((Component)this.nodeTitleJLabel, "Center");
        this.validate();
        this.setSize(this.getPreferredSize());
        if (this.getPreferredSize().width < minWidth) {
            this.setSize(minWidth, this.getHeight());
        }
        if (this.getPreferredSize().width > maxWidth) {
            this.setSize(maxWidth, this.getHeight());
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        if (this.nodeKind == 204) {
            this.setBorder(null);
            super.paintComponent(graphics);
            Color color = this.getParent().getBackground();
            graphics.setColor(color);
            NodePanel_LabeledBox.drawFilledHexagon(graphics, this.getHeight(), this.getWidth(), this.getForeground(), this.getBackground());
        } else if (defaultRoundedCornerArcWidth == 0 || defaultRoundedCornerArcHeight == 0) {
            super.paintComponent(graphics);
        } else {
            super.paintComponent(graphics);
            this.setBorder(null);
            graphics.setColor(this.getParent().getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics.setColor(this.getBackground());
            graphics.fillRoundRect(1, 1, this.getWidth() - 2, this.getHeight() - 2, defaultRoundedCornerArcWidth, defaultRoundedCornerArcHeight);
            this.paintComponents(graphics);
            graphics.setColor(defaultBorderColor);
            graphics.drawRoundRect(1, 1, this.getWidth() - 2, this.getHeight() - 2, defaultRoundedCornerArcWidth, defaultRoundedCornerArcHeight);
        }
    }
}

