package com.example.neticaj_android_demo;
/* 
 * Demo.java
 *
 * Demonstration program for Netica-J, the Netica Java Programmer's Module
 *
 *
 * Copyright (C) 2001-2012 by Norsys Software Corp.
 */

import norsys.netica.*;

public class Demo {

	//run the Demo, accessing all 
	public String run(String localDirName) throws Exception{
		StringBuffer output = new StringBuffer(); 
		Environ env = new Environ (null);

		// Read in the net created by the BuildNet.java example program
		Net net = new Net (new Streamer ( localDirName + "/ChestClinic.dne"));

		Node visitAsia    = net.getNode( "VisitAsia"    );
		Node tuberculosis = net.getNode( "Tuberculosis" );
		Node xRay         = net.getNode( "XRay"         );

		net.compile();

		double belief = tuberculosis.getBelief ("present");          
		output.append ("\nThe probability of tuberculosis is " + belief);

		xRay.finding().enterState ("abnormal");
		belief = tuberculosis.getBelief ("present");          
		output.append ("\nGiven an abnormal X-ray,\n"+
				    "the probability of tuberculosis is " + belief);

		visitAsia.finding().enterState ("visit");
		belief = tuberculosis.getBelief ("present");          
		output.append ("\nGiven an abnormal X-ray and a visit to Asia,\n" +
				       "the probability of tuberculosis is " + belief + "\n");

		net.finalize();   // not strictly necessary, but a good habit
		env.finalize();
		
		return output.toString();
	}
	
}
