/*
 * Decompiled with CFR 0.152.
 */
package norsys.netica;

import norsys.netica.Environ;
import norsys.netica.NETICA;
import norsys.netica.NeticaException;

public class RandomGenerator {
    long randGenPtr;
    Environ parentEnv;
    String seed;
    String options;
    boolean isPrivate = false;

    public RandomGenerator(String string, Environ environ, String string2) throws NeticaException {
        this.seed = string;
        this.parentEnv = environ;
        this.options = string2;
        this.randGenPtr = NETICA.NewRandomGenerator_ns(string, this.parentEnv.envPtr, string2);
        this.parentEnv.testForError();
    }

    public void finalize() throws NeticaException {
        if (this.isPrivate) {
            return;
        }
        if (this.randGenPtr == 0L) {
            throw new NeticaException(6005, "RandomGenerator.finalize(): Object has already been deleted.");
        }
        NETICA.DeleteRandomGen_ns(this.randGenPtr);
        this.parentEnv.testForError();
        this.randGenPtr = 0L;
    }

    public double generateRandomNumbers(double[] dArray, int n, String string) throws NeticaException {
        if (this.randGenPtr == 0L) {
            throw new NeticaException(6005, "RandomGenerator.finalize(): Object has already been deleted.");
        }
        double d = NETICA.GenerateRandomNumbers_ns(this.randGenPtr, dArray, n, string);
        this.parentEnv.testForError();
        return d;
    }

    public Environ getEnviron() {
        return this.parentEnv;
    }

    public String getState(String string) throws NeticaException {
        if (this.randGenPtr == 0L) {
            throw new NeticaException(6005, "RandomGenerator.finalize(): Object has already been deleted.");
        }
        String string2 = NETICA.GetRandomGenState_ns(this.randGenPtr, string);
        this.parentEnv.testForError();
        return string2;
    }
}

