"""
Loads nodes from "Cases to Learn/TanGen1.cas" intoa net,
then forms tree augmented naive Bayes.

For netica version 6.08 or later

@author: Sophie
"""

import sys, os
sys.path.append(os.path.abspath('..'))
import neticapy as netica

print(f"\nLEARN TAN TEST:\n--------------\n")

env = netica.Environ()

fname = "TanData/TanCases.cas"
cases = netica.Caseset("AllCases")
cases.add_cases_from_file(fname)
net = netica.Net("LearnedTan") # options="auto_discretize"

net.add_nodes_from_caseset(cases)
print(f"Created net from {fname} having {net.nodes.length} nodes\n")

trainCasefile = netica.Stream("Data Files\Train.csv")

trainCasefile = netica.Caseset("trainCases")
cases.add_cases_from_file("Data Files\Train.csv")

nodes = net.nodes
target = net.get_node_named("Class")
#net.learn_tan_structure(nodes, target, netica.Stream(fname)) # options="auto_layout"
net.learn_tan_structure(nodes, target, cases) # options="auto_layout"

net.revise_CPTs_by_case_file(fname,net.nodes,1)
# net.revise_CPTs_by_case_file(fname,net.nodes,1)

# learner = netica.Learner("COUNTING")
# learner.learn_CPTs(nodes, cases, 1.0)

net.write("TanData/LearnedNet.dne")

res, mesg = env.close_netica()
print(mesg)