# -*- coding: utf-8 -*-
"""
Reads in Bayes net 'ChestClinic.dne' built by the BuildNet example,
and uses it to simulate 200 random cases, which it outputs to file
'ChestClinic.cas'.

For netica version 6.05 or later

@author: Sophie
"""
import sys, os
sys.path.append(os.path.abspath('..\\src'))
import neticapy

env = neticapy.Environ()
res, mesg = env.init_netica()
print('\n' + mesg)
if res < 0:
    raise SystemExit
    
# Read in the net created by the BuildNet.py example program

orig_net = env.new_file_stream("Data Files\\ChestClinic.dne").read_net(neticapy.ReadingOption.NO_VISUAL_INFO)
orig_nodes = orig_net.nodes
orig_net.set_auto_update(0)

try:
    os.remove("Data Files\\ChestClinic.cas")
except FileNotFoundError:
    pass

casefile = env.new_file_stream("Data Files\\ChestClinic.cas")
numcases = 200
for i in range(numcases):
    orig_net.retract_findings()
    res = orig_net.generate_random_case(orig_nodes, neticapy.SamplingMethod.DEFAULT, 20, None)      
    if res >= 0:
        orig_net.write_findings(orig_nodes, casefile, i, -1)

casefile.delete()
orig_net.delete()
res, mesg = env.close_netica()
print(mesg)