# -*- coding: utf-8 -*-
"""
Enter findings and have Netica calculate new probabilities with the 
Chest Clinic example program using Netica-Py

Reads in simple Bayes net created by BuildNet.py and does Bayesian inference

For netica version 6.05 or later

@author: Sophie
"""
import neticapy as netica

env = netica.Environ()

net = netica.Net(None, "Data Files/ChestClinic.dne", "NO_VISUAL_INFO")

net.compile_net()

VisitAsia = net.get_node_named("VisitAsia")
Tuberculosis = net.get_node_named("Tuberculosis")
XRay = net.get_node_named("XRay")
Cancer = net.get_node_named("Cancer")

beliefs = Tuberculosis.get_beliefs()

print(f"\nThe probability of tuberculosis is {beliefs[0]:.6f}")

XRay.enter_finding("abnormal")
# Alternate way (executes faster)
# XRay.enter_finding(0)

XRay.enter_finding("abnormal")

print(f"\nGiven an abnormal X-ray,\n"
      f"the probability of tuberculosis is {Tuberculosis.get_beliefs()[0]:.6f}")

VisitAsia.enter_finding("visit")

print(f"\nGiven an abnormal X-ray and a visit to Asia,\n"
	  f"the probability of tuberculosis is {Tuberculosis.get_beliefs()[0]:.6f}")

Cancer.enter_finding("present")

print(f"\nGiven abnormal X-ray, Asia visit, and lung cancer,\n"
      f"the probability of tuberculosis is {Tuberculosis.get_beliefs()[0]:.6f}")

res, mesg = env.close_netica()
print('\n' + mesg)
