/* 
 * Netica.h
 *
 * Header file for Netica API, version 2.10 and greater.
 *
 * Copyright (C) 1992-2002 by Norsys Software Corp.
 * This file may be included as part of any software project.
 */

#ifndef __NeticaC_h
#define __NeticaC_h

#ifdef BUILDING_API

typedef long caseposn_bn;
typedef struct enviro environ_ns;

#include "Error.h"
#include "bnet.h"
#include "CaseFile.h"	// FIRST_CASE
#include "NeticaP.h"	// MESG_LEN_ns, etc

typedef enum {CREATE_EVENT=0x01, DUPLICATE_EVENT=0x02, REMOVE_EVENT=0x04} eventtype_ns;

enum {NEGATIVE_FINDING = -7, LIKELIHOOD_FINDING, NO_FINDING = -3};   /* for GetNodeFinding_bn */

enum {LAST_ENTRY = -10};

enum {BELIEF_UPDATE = 0x100};	/* for SetNetAutoUpdate_bn */

enum {NO_VISUAL_INFO=0, NO_WINDOW=0x10, MINIMIZED_WINDOW=0x30, REGULAR_WINDOW=0x70};   /* for ReadNet_bn */

#define prob_bn      probtype
#define util_bn      detvtype
#define state_bn     intstate
#define level_bn     leveltype
#define value_bn     detvtype
#define bool_ns      bool
#define report_ns    rept
#define stream_ns    filespec
#define net_bn       bnet
#define node_bn      bnode
#define nodelist_bn  bndlist
#define setting_bn   icase3
#define test_bn      nettest
#define sensv_bn     sensv
#define errcond_ns   errcondEN
#define errseverity_ns errseverityEN
#define checking_ns  checkAPI_EN
#define nodekind_bn  nodekindEN
#define nodetype_bn  nodetypeEN
#define eventtype_ns int

#ifdef __cplusplus
extern "C" {
#endif

#else  /* !BUILDING_API */


#ifdef __cplusplus
extern "C" {
#endif

#ifndef FALSE
enum {FALSE=0, TRUE};
#endif

typedef unsigned char bool_ns;

#define  UNDEF_DBL    undef_dbl_func_ns()
#define  INFINITY_ns  inf_dbl_func_ns()

#define  MESG_LEN_ns  256
#define  NAME_MAX_ns   30

typedef enum {NO_CHECK=1, QUICK_CHECK, REGULAR_CHECK, COMPLETE_CHECK, QUERY_CHECK=-1} checking_ns;

typedef enum {NOTHING_ERR=1, REPORT_ERR, NOTICE_ERR, WARNING_ERR, ERROR_ERR, XXX_ERR} errseverity_ns;

typedef enum {OUT_OF_MEMORY_CND=0x08, USER_ABORTED_CND=0x20, FROM_WRAPPER_CND=0x40, FROM_DEVELOPER_CND=0x80, INCONS_FINDING_CND=0x200} errcond_ns;

typedef enum {CREATE_EVENT=0x01, DUPLICATE_EVENT=0x02, REMOVE_EVENT=0x04} eventtype_ns;

typedef enum {CONTINUOUS_TYPE=1, DISCRETE_TYPE, TEXT_TYPE} nodetype_bn;

typedef enum {NATURE_NODE=1, CONSTANT_NODE, DECISION_NODE, UTILITY_NODE, DISCONNECTED_NODE} nodekind_bn;

enum {EVERY_STATE = -5, IMPOSS_STATE, UNDEF_STATE};    /* special values for state_bn */

enum {NEGATIVE_FINDING = -7, LIKELIHOOD_FINDING, NO_FINDING = -3};   /* for GetNodeFinding_bn */

enum {FIRST_CASE = -15, NEXT_CASE, NO_MORE_CASES};     /* special values for caseposn_bn */

enum {ENTROPY_SENSV = 0x02, REAL_SENSV = 0x04, VARIANCE_SENSV = 0x100};   /* for NewSensvToFinding_bn */

enum {LAST_ENTRY = -10};

enum {BELIEF_UPDATE = 0x100};	/* for SetNetAutoUpdate_bn */

enum {NO_VISUAL_INFO=0, NO_WINDOW=0x10, MINIMIZED_WINDOW=0x30, REGULAR_WINDOW=0x70};   /* for ReadNet_bn */

enum {QUERY_ns = -1};

typedef int     state_bn;
typedef float   prob_bn;
typedef float   util_bn;
typedef double  level_bn;
typedef long    caseposn_bn;

#ifndef __Netica_h

typedef struct environ__ns   environ_ns;
typedef struct report__ns    report_ns;
typedef struct stream__ns    stream_ns;
typedef struct net__bn       net_bn;
typedef struct node__bn      node_bn;
typedef struct nodelist__bn  nodelist_bn;
typedef struct setting__bn   setting_bn;
typedef struct test__bn      test_bn;
typedef struct sensv__bn     sensv_bn;

#endif /* !__Netica_h */


double undef_dbl_func_ns();                   /* use UNDEF_DBL   in your software */
double inf_dbl_func_ns();                     /* use INFINITY_ns in your software */

#endif  /* !BUILDING_API */

environ_ns* NewNeticaEnviron_ns (const char* license, environ_ns* subenv, const char* locn);
int InitNetica_bn (environ_ns** envp, char* mesg);
int CloseNetica_bn (environ_ns* env, char* mesg);
checking_ns ArgumentChecking_ns (checking_ns setting, environ_ns* env);
int VisibleGUI_ns (int setting, environ_ns* env);
int UserAllowed_ns (int setting, environ_ns* env);
double MaxMemoryUsage_ns (double max_mem, environ_ns* env);
int GetNeticaVersion_bn (const environ_ns* env, const char** version);
const char* ExecuteScript_ns (environ_ns* env, const char* language, const char* script);

report_ns* GetError_ns (environ_ns* env, errseverity_ns severity, const report_ns* after);
bool_ns ErrorCategory_ns (errcond_ns cond, const report_ns* error);
int ErrorNumber_ns (const report_ns* error);
const char* ErrorMessage_ns (const report_ns* error);
errseverity_ns ErrorSeverity_ns (const report_ns* error);
report_ns* NewError_ns (environ_ns* env, int number, errseverity_ns severity, const char* mesg);
void ClearError_ns (report_ns* error);
void ClearErrors_ns (environ_ns* env, errseverity_ns severity);

double NthProb_bn (const prob_bn* probs, state_bn state);
double NthLevel_bn (const level_bn* levels, state_bn state);
int GetChars_ns (const char* str, int index, char* dest, int num);
int NthChar_ns (const char* str, int index);
void SetNthState_bn (state_bn* states, int index, state_bn state);

stream_ns* NewStreamFile_ns (const char* filename, environ_ns* env, const char* access);
stream_ns* OpenedFileDescriptor_ns (int fd, const char* filename, environ_ns* env);
void WriteNet_bn (const net_bn* net, stream_ns* file);
net_bn* ReadNet_bn (stream_ns* file, int visual);
caseposn_bn WriteCase_bn (const nodelist_bn* nodes, stream_ns* file, long ID_num, double freq);
void ReadCase_bn (caseposn_bn* case_posn, stream_ns* file, const nodelist_bn* nodes, long* ID_num, double* freq);
int SetCaseFileDelimChar_ns (int newchar, environ_ns* env);
int SetMissingDataChar_ns (int newchar, environ_ns* env);
void DeleteStream_ns (stream_ns* file);

void EnterFinding_bn (node_bn* node, state_bn state);
void EnterFindingNot_bn (node_bn* node, state_bn state);
void EnterNodeValue_bn (node_bn* node, double value);
void EnterNodeLikelihood_bn (node_bn* node, const prob_bn* likelihood);
state_bn GetNodeFinding_bn (const node_bn* node);
const prob_bn* GetNodeLikelihood_bn (const node_bn* node);
double GetNodeValueEntered_bn (const node_bn* node);
void RetractNodeFindings_bn (node_bn* node);
void RetractNetFindings_bn (net_bn* net);

state_bn CalcNodeState_bn (node_bn* node);
double CalcNodeValue_bn (node_bn* node);

void MapStateList_bn (const state_bn* src_states,  const nodelist_bn* src_nodes,
                            state_bn* dest_states, const nodelist_bn* dest_nodes);

void CompileNet_bn (net_bn* net);
void UncompileNet_bn (net_bn* net);
bool_ns IsBeliefUpdated_bn (const node_bn* node);
const prob_bn* GetNodeBeliefs_bn (node_bn* node);
double GetNodeExpectedValue_bn (node_bn* node, double* stddev, double* x3, double* x4);
const util_bn* GetNodeExpectedUtils_bn (node_bn* node);
double JointProbability_bn (const nodelist_bn* nodes, const state_bn* states);
double FindingsProbability_bn (net_bn* net);
void MostProbableConfig_bn (const nodelist_bn* nodes, state_bn* config, int nth);
double SizeCompiledNet_bn (net_bn* net, int method);
const char* ReportJunctionTree_bn (net_bn* net);
int GenerateRandomCase_bn (const nodelist_bn* nodes, int method, double num);

nodelist_bn* NewNodeList_bn (int length, environ_ns* env);
void AddNodeToList_bn (node_bn* node, nodelist_bn* nodes, int index);
node_bn* RemoveNthNode_bn (nodelist_bn* nodes, int index);
int LengthNodeList_bn (const nodelist_bn* nodes);
node_bn* NthNode_bn (const nodelist_bn* nodes, int index);
void SetNthNode_bn (nodelist_bn* nodes, int index, node_bn* node);
int IndexOfNodeInList_bn (const node_bn* node, const nodelist_bn* nodes, int start_index);
nodelist_bn* DupNodeList_bn (const nodelist_bn* nodes);
void DeleteNodeList_bn (nodelist_bn* nodes);

void ReviseCPTsByFindings_bn (const nodelist_bn* nodes, int updating, double degree);
void ReviseCPTsByCaseFile_bn (stream_ns* file, const nodelist_bn* nodes, int updating, double degree);
void FadeCPTable_bn (node_bn* node, double degree);

setting_bn* NewSetting_bn (const nodelist_bn* nodes, bool_ns load);
void DeleteSetting_bn (setting_bn* cas);
void SetState_bn (setting_bn* cas, const node_bn* node, state_bn state);
state_bn GetState_bn (const setting_bn* cas, const node_bn* bnd);
void ZeroSetting_bn (setting_bn* cas);
bool_ns NextSetting_bn (setting_bn* cas);
void MostProbableSetting_bn (setting_bn* cas, int nth);

void ReverseLink_bn (node_bn* parent, node_bn* child);
void AbsorbNodes_bn (nodelist_bn* nodes);
void OptimizeDecisions_bn (const nodelist_bn* nodes);
void EquationToTable_bn (node_bn* node, int num_samples, bool_ns samp_unc, bool_ns add_exist);
void CopyNodeTables_bn (node_bn* dest, node_bn* src, const nodelist_bn* parent_order_dest);

net_bn* GetNthNet_bn (int nth, environ_ns* env);
net_bn* NewNet_bn (const char* name, environ_ns* env);
void DeleteNet_bn (net_bn* net);
node_bn* NewNode_bn (const char* name, int num_states, net_bn* net);
nodelist_bn* DuplicateNodes_bn (const nodelist_bn* nodes, net_bn* new_net);
void DeleteNode_bn (node_bn* node);
int AddLink_bn (node_bn* parent, node_bn* child);
void DeleteLink_bn (int link_index, node_bn* child);
void SwitchNodeParent_bn (int link_index, node_bn* node, node_bn* new_parent);

void SetNetName_bn (net_bn* net, const char* name);
int SetNetAutoUpdate_bn (net_bn* net, int autoupdate);
void SetNetElimOrder_bn (net_bn* net, const nodelist_bn* elim_order);
void SetNetTitle_bn (net_bn* net, const char* title);
void SetNetComment_bn (net_bn* net, const char* comment);
void AddNetListener_bn (net_bn* net, int callback (const net_bn* net, eventtype_ns what, void* obj, void* data), void* obj, int filter);
void SetNetUserField_bn (net_bn* net, const char* name, const void* data, int length, int kind);
void SetNetUserData_bn (net_bn* net, int kind, void* data);

void SetNodeName_bn (node_bn* node, const char* name);
void SetNodeKind_bn (node_bn* node, nodekind_bn kind);
void SetNodeStateName_bn (node_bn* node, state_bn state, const char* state_name);
void SetNodeStateNames_bn (node_bn* node, const char* state_names);
void SetNodeStateTitle_bn (node_bn* node, state_bn state, const char* state_title);
void SetNodeLevels_bn (node_bn* node, int num_states, const level_bn* levels);
void SetNodeInputName_bn (node_bn* node, int link_index, const char* link_name);
void SetNodeEquation_bn (node_bn* node, const char* eqn);
void SetNodeProbs_bn (node_bn* node, const state_bn* parent_states, const prob_bn* probs);
void SetNodeFuncState_bn (node_bn* node, const state_bn* parent_states, state_bn st);
void SetNodeFuncReal_bn (node_bn* node, const state_bn* parent_states, double val);
void SetNodeExperience_bn (node_bn* node, const state_bn* parent_states, double experience);
void DeleteNodeTables_bn (node_bn* node);
void SetNodeTitle_bn (node_bn* node, const char* title);
void SetNodeComment_bn (node_bn* node, const char* comment);
void SetNodeVisPosition_bn (node_bn* node, void* vis, double x, double y);
void AddNodeListener_bn (node_bn* node, int callback (const node_bn* node, eventtype_ns what, void* obj, void* data), void* obj, int filter);
void SetNodeUserField_bn (node_bn* node, const char* name, const void* data, int length, int kind);
void SetNodeUserData_bn (node_bn* node, int kind, void* data);

const char* GetNetName_bn (const net_bn* net);
const nodelist_bn* GetNetNodes_bn (const net_bn* net);
node_bn* NodeNamed_bn (const char* name, const net_bn* net);
int GetNetAutoUpdate_bn (const net_bn* net);
const nodelist_bn* GetNetElimOrder_bn (const net_bn* net);
const char* GetNetTitle_bn (const net_bn* net);
const char* GetNetComment_bn (const net_bn* net);
const char* GetNetFileName_bn (const net_bn* net);
const char* GetNetUserField_bn (const net_bn* net, const char* name, int* length, int kind);
void GetNetNthUserField_bn (const net_bn* net, int index, const char** name, const char** value, int* length, int kind);
void* GetNetUserData_bn (const net_bn* net, int kind);

net_bn* GetNodeNet_bn (const node_bn* node);
const char* GetNodeName_bn (const node_bn* node);
nodetype_bn GetNodeType_bn (const node_bn* node);
nodekind_bn GetNodeKind_bn (const node_bn* node);
int GetNodeNumberStates_bn (const node_bn* node);
const char* GetNodeStateName_bn (const node_bn* node, state_bn state);
const char* GetNodeStateTitle_bn (const node_bn* node, state_bn state);
state_bn StateNamed_bn (const char* name, const node_bn* node);
const level_bn* GetNodeLevels_bn (const node_bn* node);
const nodelist_bn* GetNodeParents_bn (const node_bn* node);
const nodelist_bn* GetNodeChildren_bn (const node_bn* node);
const char* GetNodeInputName_bn (const node_bn* node, int link_index);
int InputNamed_bn (const char* name, const node_bn* node);
bool_ns HasNodeTable_bn (const node_bn* node, bool_ns* complete);
bool_ns IsNodeDeterministic_bn (const node_bn* node);
const char* GetNodeEquation_bn (const node_bn* node);
const prob_bn* GetNodeProbs_bn (const node_bn* node, const state_bn* parent_states);
state_bn GetNodeFuncState_bn (const node_bn* node, const state_bn* parent_states);
double GetNodeFuncReal_bn (const node_bn* node, const state_bn* parent_states);
double GetNodeExperience_bn (const node_bn* node, const state_bn* parent_states);
const char* GetNodeTitle_bn (const node_bn* node);
const char* GetNodeComment_bn (const node_bn* node);
void GetNodeVisPosition_bn (const node_bn* node, void* vis, double* x, double* y);
const char* GetNodeUserField_bn (const node_bn* node, const char* name, int* length, int kind);
void GetNodeNthUserField_bn (const node_bn* node, int index, const char** name, const char** value, int* length, int kind);
void* GetNodeUserData_bn (const node_bn* node, int kind);

test_bn* NewNetTester_bn (const nodelist_bn* test_nodes, const nodelist_bn* unobsv_nodes, int tests);
void DeleteNetTester_bn (test_bn* test);
void TestWithFile_bn (test_bn* test, stream_ns* file);
double GetTestConfusion_bn (const test_bn* test, const node_bn* node, state_bn predicted, state_bn actual);
double GetTestErrorRate_bn (const test_bn* test, const node_bn* node);
double GetTestLogLoss_bn (const test_bn* test, const node_bn* node);
double GetTestQuadraticLoss_bn (const test_bn* test, const node_bn* node);

sensv_bn* NewSensvToFinding_bn (const node_bn* Qnode, const nodelist_bn* Fnodes, int what_find);
void DeleteSensvToFinding_bn (sensv_bn* s);
double MutualInfo_bn (sensv_bn* s, const node_bn* Fnode);
double VarianceOfReal_bn (sensv_bn* s, const node_bn* Fnode);

/* These definitions are just for compatibility with old versions: */

#ifndef BUILDING_API

enum {WILDCARD_STATE = EVERY_STATE};
#define ASSUME_NODE       CONSTANT_NODE
#define SetLinkName_bn    SetNodeInputName_bn
#define GetLinkName_bn    GetNodeInputName_bn
#define LinkNamed_bn      InputNamed_bn
#define ReOrderStates_bn  MapStateList_bn
#define GetNodeValue_bn   GetNodeValueEntered_bn
#define RandomCase_bn     GenerateRandomCase_bn
#define SetNodeCenter_bn  SetNodeVisPosition_bn
#define FreeNet_bn        DeleteNet_bn
#define FreeNodeList_bn   DeleteNodeList_bn
#define ReportError_ns    NewError_ns
#define ErrorDanger_ns    ErrorSeverity_ns
#define errdanger_ns      errseverity_ns
#define GetJointProb_bn   JointProbability_bn
#define FadeProbs_bn      FadeCPTable_bn
#define RetractAllFindings_bn RetractNetFindings_bn
#define DeleteNodeRelation_bn DeleteNodeTables_bn
#define CaseProbability_bn    FindingsProbability_bn
#define GetNodeCalcState_bn   CalcNodeState_bn
#define GetNodeCalcValue_bn   CalcNodeValue_bn
#define CaseRevisesProbs_bn		ReviseCPTsByFindings_bn
#define CaseFileRevisesProbs_bn	ReviseCPTsByCaseFile_bn
extern double BaseExperience_bn;
static stream_ns* FileNamed_ns (const char* filename, environ_ns* env){
	return NewStreamFile_ns (filename, env, 0);
	}
#define GetNodeLevel_bn(node, state)  (GetNodeLevels_bn (node) ? GetNodeLevels_bn (node) [state] : UNDEF_DBL)
#define GetNodeDiscrete_bn GetNodeDiscrete1_bn
static bool_ns HasRelation_bn (const node_bn* node){
	return HasNodeTable_bn (node, 0);
	}
static bool_ns GetNodeDiscrete1_bn (const node_bn* node){
	return (GetNodeType_bn (node) == DISCRETE_TYPE) ? TRUE : FALSE;
	}
#define SetNodeFuncValue_bn  SetNodeFuncValue1_bn
static void SetNodeFuncValue1_bn (node_bn* node, const state_bn* parent_states, double func_value){
	if (GetNodeType_bn (node) == DISCRETE_TYPE)
	     SetNodeFuncState_bn (node, parent_states, (int)func_value);
	else SetNodeFuncReal_bn (node, parent_states, func_value);
	}
#define GetNodeFuncValue_bn  GetNodeFuncValue1_bn
static double GetNodeFuncValue1_bn (const node_bn* node, const state_bn* parent_states){
	if (GetNodeType_bn (node) == DISCRETE_TYPE)
	     return GetNodeFuncState_bn (node, parent_states);
	else return GetNodeFuncReal_bn (node, parent_states);
	}
static environ_ns* NewNeticaEnviron_bn (const char* license){
	return NewNeticaEnviron_ns (license, 0, 0);
	}
static void GetNodeCenter_bn (const node_bn* node, void* vis, int* x, int* y){
	double xd, yd;
	GetNodeVisPosition_bn (node, vis, &xd, &yd);
	if (x) *x = (int)xd;
	if (y) *y = (int)yd;
	}

#endif  /* !BUILDING_API */

/* End compatibility definitions */

#ifdef __cplusplus
}
#endif

#endif  /* __NeticaC_h */
