/*
 * Decompiled with CFR 0.152.
 */
package norsys.netica;

import java.io.InputStream;
import java.util.Vector;
import norsys.netica.Environ;
import norsys.netica.Generic;
import norsys.netica.NETICA;
import norsys.netica.NeticaEvent;
import norsys.netica.NeticaException;
import norsys.netica.Node;
import norsys.netica.NodeList;
import norsys.netica.Streamer;
import norsys.netica.Util;

public class Net
extends Generic {
    long netPtr;
    long callbackPtr;
    private Object userData;
    private static String constructorClass = "norsys.netica.Net";
    static int objectCount = 0;
    public static final long FIRST_CASE = -15L;
    public static final long NEXT_CASE = -14L;
    public static final long NO_MORE_CASES = -13L;
    public static final int BELIEF_UPDATE = 1;
    static final int NO_WINDOW = 1;

    static synchronized int newObjectCount() {
        return ++objectCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Net(Environ environ) throws NeticaException {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            long l = NETICA.NewNet_bn("Unnamed_" + Net.newObjectCount(), environ.envPtr);
            environ.testForError();
            this.hookupToNative(l, environ);
        }
    }

    public Net() throws NeticaException {
        this(Environ.getDefaultEnviron());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Net(Streamer streamer) throws NeticaException {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            this.parentEnv = streamer.parentEnv;
            this.netPtr = NETICA.ReadNet_bn(streamer.streamPtr, 1);
            this.parentEnv.testForError();
            this.hookupToNative(this.netPtr, this.parentEnv);
        }
    }

    private void hookupToNative(long l, Environ environ) throws NeticaException {
        this.parentEnv = environ;
        this.netPtr = l;
        NETICA.SetJavaApiNet_bn(l, this);
        this.callbackPtr = NETICA.AddNetListener_bn(l, 0L, this, -1);
        environ.testForError();
        Util.log("NETICA: created Net: " + this.getName());
    }

    void onDeleteCallback(NeticaEvent neticaEvent) throws NeticaException {
        if (neticaEvent.getObject() != this) {
            Util.log(" *** WARNING *** NETICA_J. Net.onDeleteCallback().  Notified of event on object I'm not listening to:   event.id=" + neticaEvent.getKind() + "    Event was on object" + neticaEvent.getObject());
            return;
        }
        NETICA.AddNetListener_bn(this.netPtr, this.callbackPtr, this, 0);
        Util.log(" *** INFO: Net set opaque ptr to 0;  was " + this.netPtr);
        if (Util.devel) {
            System.out.println(" *** NET:onDeleteCallback SUCCESS!!");
        }
        this.netPtr = 0L;
    }

    public static String getConstructorClassName() {
        return Net.getConstructorClassName();
    }

    public static String getConstructorClass() {
        return constructorClass;
    }

    public static void setConstructorClassName(String string) throws NeticaException {
        Net.setConstructorClass(string);
    }

    public static void setConstructorClass(String string) throws NeticaException {
        Class<?> clazz;
        Class<?> clazz2;
        Object var1_1 = null;
        try {
            clazz2 = Class.forName(string);
            clazz = Class.forName("norsys.netica.Net");
        }
        catch (Exception exception) {
            throw new NeticaException(6001, "The class " + string + " could not be found on the classpath.");
        }
        if (!clazz.isAssignableFrom(clazz2)) {
            throw new NeticaException(6002, string + " is not an extension of norsys.netica.Net");
        }
        constructorClass = string;
    }

    static Net getNetFromPtr(long l, Environ environ) throws NeticaException {
        Net net = NETICA.GetJavaApiNet_bn(l);
        if (net == null) {
            try {
                Class<?> clazz = Class.forName(Net.getConstructorClass());
                net = (Net)clazz.newInstance();
                Util.log("constructed new net from ptr.");
            }
            catch (Exception exception) {
                throw new NeticaException(6000, "Internal error during Net constuction: Invalid Class:" + exception.getMessage());
            }
            net.hookupToNative(l, environ);
        } else {
            Util.log("**** SUCCESSFULLY reusing a Net, YIPPEE!!!");
        }
        return net;
    }

    void assertNetIsViable() throws NeticaException {
        if (this.parentEnv == null || this.parentEnv.envPtr == 0L) {
            throw new NeticaException(6005, "The Environ associated with this object has been closed and so this object should no longer be used.");
        }
        if (this.netPtr == 0L) {
            throw new NeticaException(6005, "Native net object no longer exists, so this Net should no longer be used.");
        }
    }

    public void compile() throws NeticaException {
        NETICA.CompileNet_bn(this.netPtr);
        this.parentEnv.testForError();
        Util.log("NETICA: compiled Net: " + this.getName());
    }

    public void uncompile() throws NeticaException {
        NETICA.UncompileNet_bn(this.netPtr);
        this.parentEnv.testForError();
        Util.log("NETICA: uncompiled Net: " + this.getName());
    }

    public Node getNode(String string) throws NeticaException {
        long l = NETICA.NodeNamed_bn(string, this.netPtr);
        this.parentEnv.testForError();
        if (l == 0L) {
            return null;
        }
        Node node = Node.getNodeFromPtr(l, this);
        this.parentEnv.testForError();
        return node;
    }

    public void finalize() throws NeticaException {
        if (this.netPtr != 0L) {
            NETICA.AddNetListener_bn(this.netPtr, this.callbackPtr, this, 0);
            this.delete();
        }
    }

    public void delete() throws NeticaException {
        if (this.netPtr == 0L) {
            throw new NeticaException(6005, "Net.delete(): Native net was already deleted.");
        }
        String string = this.getName();
        NETICA.DeleteNet_bn(this.netPtr);
        this.parentEnv.testForError();
        Util.log("NETICA: deleted Net: " + string);
    }

    public int generateRandomCase(NodeList nodeList, int n, double d) throws NeticaException {
        long l = nodeList.getNodeListPtr();
        int n2 = NETICA.GenerateRandomCase_bn(l, n, d);
        this.parentEnv.testForError();
        NETICA.DeleteNodeList_bn(l);
        this.parentEnv.testForError();
        return n2;
    }

    public NodeList getNodes() throws NeticaException {
        long l = NETICA.GetNetNodes_bn(this.netPtr);
        this.parentEnv.testForError();
        return new NodeList(l, this);
    }

    public int getAutoUpdate() throws NeticaException {
        int n = NETICA.GetNetAutoUpdate_bn(this.netPtr);
        this.parentEnv.testForError();
        return n;
    }

    public void setAutoUpdate(int n) throws NeticaException {
        NETICA.SetNetAutoUpdate_bn(this.netPtr, n);
        this.parentEnv.testForError();
    }

    public double getFindingsProbability() throws NeticaException {
        double d = NETICA.FindingsProbability_bn(this.netPtr);
        this.parentEnv.testForError();
        return d;
    }

    public NodeList getElimOrder() throws NeticaException {
        long l = NETICA.GetNetElimOrder_bn(this.netPtr);
        this.parentEnv.testForError();
        if (l == 0L) {
            return null;
        }
        return new NodeList(l, this);
    }

    public void setElimOrder(NodeList nodeList) throws NeticaException {
        if (nodeList == null) {
            NETICA.SetNetElimOrder_bn(this.netPtr, 0L);
        } else {
            long l = nodeList.getNodeListPtr();
            NETICA.SetNetElimOrder_bn(this.netPtr, l);
            this.parentEnv.testForError();
            NETICA.DeleteNodeList_bn(l);
        }
        this.parentEnv.testForError();
    }

    public double getJointProbability(NodeList nodeList, int[] nArray) throws NeticaException {
        long l = nodeList.getNodeListPtr();
        double d = NETICA.JointProbability_bn(l, nArray);
        this.parentEnv.testForError();
        NETICA.DeleteNodeList_bn(l);
        this.parentEnv.testForError();
        return d;
    }

    public void retractFindings() throws NeticaException {
        NETICA.RetractNetFindings_bn(this.netPtr);
        this.parentEnv.testForError();
    }

    public void reviseCPTsByFindings(NodeList nodeList, double d) throws NeticaException {
        long l = nodeList.getNodeListPtr();
        NETICA.ReviseCPTsByFindings_bn(l, 0, d);
        this.parentEnv.testForError();
        NETICA.DeleteNodeList_bn(l);
        this.parentEnv.testForError();
    }

    void reviseCPTsByCaseFile(InputStream inputStream, NodeList nodeList, double d) throws NeticaException {
        Streamer streamer = new Streamer(inputStream, this.parentEnv);
        this.reviseCPTsByCaseFile(streamer, nodeList, d);
        streamer.finalize();
    }

    public void reviseCPTsByCaseFile(Streamer streamer, NodeList nodeList, double d) throws NeticaException {
        long l = nodeList.getNodeListPtr();
        NETICA.ReviseCPTsByCaseFile_bn(streamer.streamPtr, l, 0, d);
        this.parentEnv.testForError();
        NETICA.DeleteNodeList_bn(l);
        this.parentEnv.testForError();
    }

    public void write(Streamer streamer) throws NeticaException {
        NETICA.WriteNet_bn(this.netPtr, streamer.streamPtr);
        this.parentEnv.testForError();
    }

    public long writeCase(NodeList nodeList, Streamer streamer, long l, double d) throws NeticaException {
        long l2 = nodeList.getNodeListPtr();
        long l3 = NETICA.WriteCase_bn(l2, streamer.streamPtr, l, d);
        this.parentEnv.testForError();
        NETICA.DeleteNodeList_bn(l2);
        this.parentEnv.testForError();
        return l3;
    }

    public void readCase(long[] lArray, Streamer streamer, NodeList nodeList, long[] lArray2, double[] dArray) throws NeticaException {
        long l = nodeList.getNodeListPtr();
        NETICA.ReadCase_bn(lArray, streamer.streamPtr, l, lArray2, dArray);
        this.parentEnv.testForError();
        NETICA.DeleteNodeList_bn(l);
        this.parentEnv.testForError();
    }

    public void absorb(NodeList nodeList) throws NeticaException {
        long l = nodeList.getNodeListPtr();
        NETICA.AbsorbNodes_bn(l);
        this.parentEnv.testForError();
    }

    public int[] getMostProbableConfig(NodeList nodeList) throws NeticaException {
        int[] nArray = new int[nodeList.size()];
        long l = nodeList.getNodeListPtr();
        NETICA.MostProbableConfig_bn(l, nArray, 0);
        this.parentEnv.testForError();
        NETICA.DeleteNodeList_bn(l);
        this.parentEnv.testForError();
        return nArray;
    }

    public void optimizeDecisions(NodeList nodeList) throws NeticaException {
        long l = nodeList.getNodeListPtr();
        NETICA.OptimizeDecisions_bn(l);
        this.parentEnv.testForError();
        NETICA.DeleteNodeList_bn(l);
        this.parentEnv.testForError();
    }

    public static NodeList duplicateNodes(NodeList nodeList, Net net) throws NeticaException {
        long l = NETICA.DuplicateNodes_bn(nodeList.getNodeListPtr(), net.netPtr);
        net.getEnviron().testForError();
        return new NodeList(l, net);
    }

    public NodeList duplicateNodes(NodeList nodeList) throws NeticaException {
        if (nodeList == null) {
            throw new NeticaException("nodeList is null; cannot duplicate nodes.");
        }
        long l = NETICA.DuplicateNodes_bn(nodeList.getNodeListPtr(), this.netPtr);
        this.parentEnv.testForError();
        return new NodeList(l, this);
    }

    public String getFileName() throws NeticaException {
        String string = NETICA.GetNetFileName_bn(this.netPtr);
        this.parentEnv.testForError();
        if (string.equals("")) {
            return null;
        }
        return string;
    }

    public String reportJunctionTree() throws NeticaException {
        String string = NETICA.ReportJunctionTree_bn(this.netPtr);
        this.parentEnv.testForError();
        return string;
    }

    public double sizeCompiled() throws NeticaException {
        double d = NETICA.SizeCompiledNet_bn(this.netPtr, 0);
        this.parentEnv.testForError();
        return d;
    }

    public static synchronized Vector getAllNets(Environ environ) throws NeticaException {
        Vector<Net> vector = new Vector<Net>();
        int n = 0;
        while (true) {
            long l = NETICA.GetNthNet_bn(n++, environ.envPtr);
            environ.testForError();
            if (l == 0L) break;
            vector.add(Net.getNetFromPtr(l, environ));
        }
        return vector;
    }
}

