/*
 * Decompiled with CFR 0.152.
 */
package norsys.neticaEx;

import norsys.netica.Net;
import norsys.netica.NeticaException;
import norsys.netica.Node;
import norsys.netica.NodeList;

public class NodeListEx
extends NodeList {
    public NodeListEx(Net net) throws NeticaException {
        super(net);
    }

    public NodeListEx(NodeList nodeList) throws NeticaException {
        super(nodeList);
    }

    public static NodeList mapNodeList(NodeList nodeList, Net net) throws NeticaException {
        NodeList nodeList2 = new NodeList(net);
        int n = 0;
        while (n < nodeList.size()) {
            Node node = (Node)nodeList.get(n);
            Node node2 = net.getNode(node.getName());
            nodeList2.add(node2);
            ++n;
        }
        return nodeList2;
    }

    public static boolean nextStates(int[] nArray, NodeList nodeList) throws NeticaException {
        int n = nodeList.size() - 1;
        while (n >= 0) {
            Node node = (Node)nodeList.get(n);
            int n2 = n;
            nArray[n2] = nArray[n2] + 1;
            if (nArray[n2] < node.getNumStates()) {
                return false;
            }
            nArray[n] = 0;
            --n;
        }
        return true;
    }

    public static double sizeCartesianProduct(NodeList nodeList) throws NeticaException {
        double d = 1.0;
        int n = 0;
        while (n < nodeList.size()) {
            Node node = (Node)nodeList.get(n);
            int n2 = node.getNumStates();
            if (n2 == 0) {
                return 0.0;
            }
            if ((double)n2 + 1.0 > Double.MAX_VALUE / d) {
                return Double.MAX_VALUE;
            }
            d *= (double)n2;
            ++n;
        }
        return d;
    }

    public static void deleteNodes(NodeList nodeList) throws NeticaException {
        while (nodeList.size() > 0) {
            Node node = (Node)nodeList.remove(0);
            node.delete();
        }
    }

    public int findNodeNamed(String string) throws NeticaException {
        if (this.size() == 0) {
            return -1;
        }
        Net net = this.getNet();
        Node node = net.getNode(string);
        if (node == null) {
            return -1;
        }
        return this.indexOf(node);
    }

    public static NodeList transferNodes(NodeList nodeList, Net net) throws NeticaException {
        NodeList nodeList2 = net.duplicateNodes(nodeList);
        while (nodeList.size() > 0) {
            Node node = (Node)nodeList.remove(0);
            node.delete();
        }
        return nodeList2;
    }
}

