/* 
 *  DoInference.java
 *
 *  Example use of Netica-J for doing probabilistic inference.
 */
import norsys.netica.*;
     
public class DoInference {

  public static void main (String[] args){
    try {
	Environ env = new Environ (null);

	// Read in the net created by the BuildNet.java example program
	Net net = new Net (new Streamer ("AsiaEx.dne"));

	Node visitAsia    = net.getNode( "VisitAsia"    );
	Node tuberculosis = net.getNode( "Tuberculosis" );
	Node xRay         = net.getNode( "XRay"         );

	net.compile();

	double belief = tuberculosis.getBelief ("present");          
	System.out.println ("\nThe probability of tuberculosis is " + belief);

	xRay.enterFinding ("abnormal");
	belief = tuberculosis.getBelief ("present");          
	System.out.println ("\nGiven an abnormal X-ray,\n"+
			    "the probability of tuberculosis is " + belief);

	visitAsia.enterFinding ("visit");
	belief = tuberculosis.getBelief ("present");          
	System.out.println ("\nGiven an abnormal X-ray and a visit to Asia,\n" +
			    "the probability of tuberculosis is " + belief + "\n");

	net.finalize();   // not strictly necessary, but a good habit
    }
    catch (Exception e) {
	e.printStackTrace();
    }
  }
}
