/*
 * Decompiled with CFR 0.152.
 */
package norsys.netica;

import norsys.netica.Environ;
import norsys.netica.NETICA;
import norsys.netica.NeticaException;
import norsys.netica.Streamer;

public class Caseset {
    Environ parentEnv;
    long casesetPtr = 0L;

    public Caseset() throws NeticaException {
        this(Environ.getDefaultEnviron());
    }

    public Caseset(Environ environ) throws NeticaException {
        this.parentEnv = environ;
        this.casesetPtr = NETICA.NewCaseset_cs(this.parentEnv.envPtr);
        this.parentEnv.testForError();
    }

    Caseset(long l, Environ environ) {
        this.casesetPtr = l;
        this.parentEnv = environ;
    }

    public void addCases(Streamer streamer, double d) throws NeticaException {
        NETICA.AddFileToCaseset_cs(streamer.streamPtr, this.casesetPtr, d);
        this.parentEnv.testForError();
    }

    public void finalize() throws NeticaException {
        if (this.casesetPtr == 0L) {
            throw new NeticaException(6005, "Caseset.finalize(): Object has already been deleted.");
        }
        NETICA.DeleteCaseset_cs(this.casesetPtr);
        this.parentEnv.testForError();
        this.casesetPtr = 0L;
    }

    public Environ getEnviron() {
        return this.parentEnv;
    }

    public void writeCases(Streamer streamer) throws NeticaException {
        NETICA.WriteCaseset_cs(this.casesetPtr, streamer.streamPtr);
        this.parentEnv.testForError();
    }

    long getCasesetPtr() {
        return this.casesetPtr;
    }
}

