/*
 * Decompiled with CFR 0.152.
 */
package norsys.netica;

import norsys.netica.Caseset;
import norsys.netica.Environ;
import norsys.netica.NETICA;
import norsys.netica.NeticaException;
import norsys.netica.NodeList;

public class DatabaseManager {
    Environ parentEnv;
    long dbmgrPtr;

    public DatabaseManager(String string, boolean bl, Environ environ) throws NeticaException {
        if (environ == null) {
            environ = Environ.getDefaultEnviron();
        }
        this.parentEnv = environ;
        this.dbmgrPtr = NETICA.NewDBMgr_cs(string, bl ? 1 : 0, environ.envPtr);
        environ.testForError();
        if (this.dbmgrPtr == 0L) {
            throw new NeticaException("Connection failed to ODBC Server: " + string + ";  ODBC service may be unavailable, or username/password may be incorrect.");
        }
    }

    public void execSql(String string) throws NeticaException {
        NETICA.ExecDBSql_cs(this.dbmgrPtr, string);
        this.parentEnv.testForError();
    }

    public void finalize() throws NeticaException {
        if (this.dbmgrPtr == 0L) {
            return;
        }
        NETICA.DeleteDBMgr_cs(this.dbmgrPtr);
        this.parentEnv.testForError();
        this.dbmgrPtr = 0L;
    }

    public Environ getEnviron() throws NeticaException {
        return this.parentEnv;
    }

    public void insertFindings(NodeList nodeList, String string, String string2) throws NeticaException {
        long l = nodeList.getNodeListPtr();
        NETICA.InsertFindingsIntoDB_bn(this.dbmgrPtr, l, string, string2);
        this.parentEnv.testForError();
    }

    public Caseset getCases(NodeList nodeList, String string, String string2, String string3) throws NeticaException {
        long l = nodeList.getNodeListPtr();
        long l2 = NETICA.NewCasesetFromDB_bn(this.dbmgrPtr, l, string, string2, string3);
        this.parentEnv.testForError();
        return new Caseset(l2, this.parentEnv);
    }
}

