/*
 * Decompiled with CFR 0.152.
 */
package norsys.netica;

import java.util.Enumeration;
import java.util.Hashtable;
import norsys.netica.Environ;
import norsys.netica.NETICA;
import norsys.netica.Net;
import norsys.netica.NeticaEvent;
import norsys.netica.NeticaException;
import norsys.netica.NeticaListener;
import norsys.netica.Node;
import norsys.netica.State;
import norsys.netica.User;
import norsys.netica.Util;

public abstract class General
implements NeticaListener {
    public static final int NAME_MAX = 30;
    static final int NO_TYPE = 0;
    static final int NET_TYPE = 1;
    static final int NODE_TYPE = 2;
    static final int STATE_TYPE = 3;
    static final String[] typeName = new String[]{"noType", "Net", "Node", "State"};
    int parentType = 0;
    Environ parentEnv;
    private Hashtable listeners = new Hashtable();
    private User userObj;

    General() throws NeticaException {
        if (this instanceof Net) {
            this.parentType = 1;
        } else if (this instanceof Node) {
            this.parentType = 2;
        } else if (this instanceof State) {
            this.parentType = 3;
        }
    }

    long getPtr() throws NeticaException {
        switch (this.parentType) {
            case 1: {
                return ((Net)this).netPtr;
            }
            case 2: {
                return ((Node)this).nodePtr;
            }
            case 3: {
                return ((State)this).parent.nodePtr;
            }
        }
        return 0L;
    }

    private int getStateIndex() {
        return ((State)this).stateIndex;
    }

    public void addListener(NeticaListener neticaListener) throws NeticaException {
        if (neticaListener != this) {
            this.listeners.put(neticaListener, neticaListener);
        } else {
            long l = 0L;
            switch (this.parentType) {
                case 1: {
                    l = NETICA.AddNetListener_bn(this.getPtr(), 0L, neticaListener, -1);
                    break;
                }
                case 2: {
                    l = NETICA.AddNodeListener_bn(this.getPtr(), 0L, neticaListener, -1);
                    break;
                }
                case 3: {
                    throw new NeticaException("unsupported General feature for States");
                }
            }
            this.parentEnv.testForError();
            this.listeners.put(neticaListener, new Long(l));
        }
    }

    public void eventOccurred(NeticaEvent neticaEvent) {
        try {
            Enumeration enumeration = this.listeners.elements();
            while (enumeration.hasMoreElements()) {
                Object v = enumeration.nextElement();
                if (v == this || !(v instanceof NeticaListener)) continue;
                NeticaListener neticaListener = (NeticaListener)v;
                neticaListener.eventOccurred(neticaEvent);
            }
            Util.log("*** " + typeName[this.parentType] + ".eventOccurred() was called with event.id = " + neticaEvent.getKind());
            block1 : switch (neticaEvent.getKind()) {
                case 4: {
                    switch (this.parentType) {
                        case 1: {
                            ((Net)this).onDeleteCallback(neticaEvent);
                            break block1;
                        }
                        case 2: {
                            ((Node)this).onDeleteCallback(neticaEvent);
                            break block1;
                        }
                        case 3: {
                            return;
                        }
                    }
                    break;
                }
            }
        }
        catch (Exception exception) {
            System.err.println("********************************************************* ");
            System.err.println("**  Netica-J Internal Error in General.eventOccurred() ** ");
            System.err.println("**  Please inform Norsys by e-mailing info@norsys.com  ** ");
            System.err.println("**  this instanceof " + this.getClass().getName() + " ** ");
            System.err.println("**  typeName[parentType] = " + typeName[this.parentType] + " ** ");
            System.err.println("********************************************************* ");
            exception.printStackTrace();
        }
    }

    public String getComment() throws NeticaException {
        String string = null;
        switch (this.parentType) {
            case 1: {
                string = NETICA.GetNetComment_bn(this.getPtr());
                break;
            }
            case 2: {
                string = NETICA.GetNodeComment_bn(this.getPtr());
                break;
            }
            case 3: {
                string = NETICA.GetNodeStateComment_bn(this.getPtr(), this.getStateIndex());
            }
        }
        this.parentEnv.testForError();
        return string;
    }

    public Environ getEnviron() throws NeticaException {
        this.parentEnv.testForError();
        return this.parentEnv;
    }

    String getIcon() throws NeticaException {
        String string = null;
        switch (this.parentType) {
            case 1: {
                string = NETICA.GetNetIcon_bn(this.getPtr());
                break;
            }
            case 2: {
                string = NETICA.GetNodeIcon_bn(this.getPtr());
                break;
            }
            case 3: {
                throw new NeticaException("unsupported General feature for states");
            }
        }
        this.parentEnv.testForError();
        return string;
    }

    public String getName() throws NeticaException {
        String string = null;
        switch (this.parentType) {
            case 1: {
                string = NETICA.GetNetName_bn(this.getPtr());
                break;
            }
            case 2: {
                string = NETICA.GetNodeName_bn(this.getPtr());
                break;
            }
            case 3: {
                string = NETICA.GetNodeStateName_bn(this.getPtr(), this.getStateIndex());
                if (string != null && !string.equals("")) break;
                string = "s" + this.getStateIndex();
            }
        }
        this.parentEnv.testForError();
        return string;
    }

    public String getTitle() throws NeticaException {
        String string = null;
        switch (this.parentType) {
            case 1: {
                string = NETICA.GetNetTitle_bn(this.getPtr());
                break;
            }
            case 2: {
                string = NETICA.GetNodeTitle_bn(this.getPtr());
                break;
            }
            case 3: {
                string = NETICA.GetNodeStateTitle_bn(this.getPtr(), this.getStateIndex());
            }
        }
        this.parentEnv.testForError();
        return string;
    }

    public void removeListener(NeticaListener neticaListener) throws NeticaException {
        if (this.parentType == 3) {
            throw new NeticaException("unsupported General feature for States");
        }
        if (neticaListener != this) {
            this.listeners.remove(neticaListener);
        } else {
            Object v = this.listeners.get(neticaListener);
            if (v == null) {
                throw new NeticaException("The object supplied is not on record as a current listener; you must call addListener() with a NeticaListener object before calling removeListener() on the same object.");
            }
            if (!(v instanceof Long)) {
                throw new NeticaException("Internal error in Netica-J. Please inform Norsys at netica-j@norsys.com.");
            }
            Long l = (Long)v;
            long l2 = l;
            switch (this.parentType) {
                case 1: {
                    NETICA.AddNetListener_bn(this.getPtr(), l2, neticaListener, 0);
                    break;
                }
                case 2: {
                    NETICA.AddNodeListener_bn(this.getPtr(), l2, neticaListener, 0);
                    break;
                }
                case 3: {
                    throw new NeticaException("unsupported General feature for States");
                }
            }
        }
    }

    public void setComment(String string) throws NeticaException {
        switch (this.parentType) {
            case 1: {
                NETICA.SetNetComment_bn(this.getPtr(), string);
                break;
            }
            case 2: {
                NETICA.SetNodeComment_bn(this.getPtr(), string);
                break;
            }
            case 3: {
                NETICA.SetNodeStateComment_bn(this.getPtr(), this.getStateIndex(), string);
            }
        }
        this.parentEnv.testForError();
    }

    void setIcon(String string) throws NeticaException {
        switch (this.parentType) {
            case 1: {
                NETICA.SetNetIcon_bn(this.getPtr(), string);
                break;
            }
            case 2: {
                NETICA.SetNodeIcon_bn(this.getPtr(), string);
                break;
            }
            case 3: {
                throw new NeticaException("unsupported General feature for states");
            }
        }
        this.parentEnv.testForError();
    }

    public void setName(String string) throws NeticaException {
        switch (this.parentType) {
            case 1: {
                NETICA.SetNetName_bn(this.getPtr(), string);
                break;
            }
            case 2: {
                NETICA.SetNodeName_bn(this.getPtr(), string);
                break;
            }
            case 3: {
                NETICA.SetNodeStateName_bn(this.getPtr(), this.getStateIndex(), string);
            }
        }
        this.parentEnv.testForError();
    }

    public void setTitle(String string) throws NeticaException {
        switch (this.parentType) {
            case 1: {
                NETICA.SetNetTitle_bn(this.getPtr(), string);
                break;
            }
            case 2: {
                NETICA.SetNodeTitle_bn(this.getPtr(), string);
                break;
            }
            case 3: {
                NETICA.SetNodeStateTitle_bn(this.getPtr(), this.getStateIndex(), string);
            }
        }
        this.parentEnv.testForError();
    }

    public String toString() {
        try {
            return this.getName();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public User user() throws NeticaException {
        if (this.parentType == 3) {
            throw new NeticaException("State objects do not currently support User objects.");
        }
        if (this.userObj == null) {
            this.userObj = new User(this);
        }
        return this.userObj;
    }
}

