/*
 * Decompiled with CFR 0.152.
 */
package norsys.netica;

import norsys.netica.Caseset;
import norsys.netica.Environ;
import norsys.netica.NETICA;
import norsys.netica.NeticaException;
import norsys.netica.NodeList;

public class Learner {
    Environ parentEnv;
    long learnerPtr;
    int method;
    public static int COUNTING_LEARNING = 1;
    public static int EM_LEARNING = 3;
    public static int GRADIENT_DESCENT_LEARNING = 4;
    static int SEQUENTIAL_UPDATING_LEARNING = 2;

    public Learner(int n) throws NeticaException {
        this(n, Environ.getDefaultEnviron());
    }

    public Learner(int n, Environ environ) throws NeticaException {
        this.parentEnv = environ;
        this.method = n;
        this.learnerPtr = NETICA.NewLearner_bn(n, this.parentEnv.envPtr);
        this.parentEnv.testForError();
    }

    public void finalize() throws NeticaException {
        if (this.learnerPtr == 0L) {
            throw new NeticaException(6005, "Learner.finalize(): Object has already been deleted.");
        }
        NETICA.DeleteLearner_bn(this.learnerPtr);
        this.parentEnv.testForError();
        this.learnerPtr = 0L;
    }

    public Environ getEnviron() {
        return this.parentEnv;
    }

    public int getMaxIterations() throws NeticaException {
        int n = NETICA.SetLearnerMaxIters_bn(this.learnerPtr, 1);
        this.parentEnv.testForError();
        NETICA.SetLearnerMaxIters_bn(this.learnerPtr, n);
        this.parentEnv.testForError();
        return n;
    }

    public double getMaxTolerance() throws NeticaException {
        double d = NETICA.SetLearnerMaxTol_bn(this.learnerPtr, 1.0);
        this.parentEnv.testForError();
        NETICA.SetLearnerMaxTol_bn(this.learnerPtr, d);
        this.parentEnv.testForError();
        return d;
    }

    public int getMethod() {
        return this.method;
    }

    public void learnCPTs(NodeList nodeList, Caseset caseset, double d) throws NeticaException {
        long l = nodeList.getNodeListPtr();
        NETICA.LearnCPTs_bn(this.learnerPtr, l, caseset.getCasesetPtr(), d);
        this.parentEnv.testForError();
        NETICA.DeleteNodeList_bn(l);
    }

    public void setMaxIterations(int n) throws NeticaException {
        NETICA.SetLearnerMaxIters_bn(this.learnerPtr, n);
        this.parentEnv.testForError();
    }

    public void setMaxTolerance(double d) throws NeticaException {
        NETICA.SetLearnerMaxTol_bn(this.learnerPtr, d);
        this.parentEnv.testForError();
    }
}

