/*
 * Decompiled with CFR 0.152.
 */
package norsys.netica;

import java.io.InputStream;
import norsys.netica.Environ;
import norsys.netica.NETICA;
import norsys.netica.NeticaException;
import norsys.netica.Node;
import norsys.netica.NodeList;
import norsys.netica.Streamer;

public class NetTester {
    long netTesterPtr;
    Environ parentEnv;

    public NetTester(NodeList nodeList, NodeList nodeList2, int n) throws NeticaException {
        this.parentEnv = nodeList.parentEnv;
        this.netTesterPtr = NETICA.NewNetTester_bn(nodeList == null ? 0L : nodeList.getNodeListPtr(), nodeList2 == null ? 0L : nodeList2.getNodeListPtr(), n);
        this.parentEnv.testForError();
    }

    public void finalize() throws NeticaException {
        if (this.netTesterPtr == 0L) {
            return;
        }
        NETICA.DeleteNetTester_bn(this.netTesterPtr);
        this.parentEnv.testForError();
        this.netTesterPtr = 0L;
    }

    public double getConfusion(Node node, int n, int n2) throws NeticaException {
        double d = NETICA.GetTestConfusion_bn(this.netTesterPtr, node.nodePtr, n, n2);
        this.parentEnv.testForError();
        return d;
    }

    public double getErrorRate(Node node) throws NeticaException {
        double d = NETICA.GetTestErrorRate_bn(this.netTesterPtr, node.nodePtr);
        this.parentEnv.testForError();
        return d;
    }

    public double getLogLoss(Node node) throws NeticaException {
        double d = NETICA.GetTestLogLoss_bn(this.netTesterPtr, node.nodePtr);
        this.parentEnv.testForError();
        return d;
    }

    public double getQuadraticLoss(Node node) throws NeticaException {
        double d = NETICA.GetTestQuadraticLoss_bn(this.netTesterPtr, node.nodePtr);
        this.parentEnv.testForError();
        return d;
    }

    void testWithFile(InputStream inputStream, String string) throws NeticaException {
        Streamer streamer = new Streamer(inputStream, string, this.parentEnv);
        this.testWithFile(streamer);
        streamer.finalize();
    }

    public void testWithFile(Streamer streamer) throws NeticaException {
        NETICA.TestWithFile_bn(this.netTesterPtr, streamer.streamPtr);
        this.parentEnv.testForError();
    }
}

