/*
 * Decompiled with CFR 0.152.
 */
package norsys.netica;

import java.util.Enumeration;
import java.util.Vector;
import norsys.netica.Environ;
import norsys.netica.NETICA;
import norsys.netica.Net;
import norsys.netica.NeticaException;
import norsys.netica.Node;
import norsys.netica.Util;

public class NodeList
extends Vector {
    Net parentNet;
    Environ parentEnv;

    public NodeList(Net net) throws NeticaException {
        super(100);
        this.parentNet = net;
        this.parentEnv = net.parentEnv;
        Util.log("NETICA: created empty NodeList of initialCapacity 100");
    }

    public NodeList(NodeList nodeList) throws NeticaException {
        super(nodeList);
        this.parentNet = nodeList.parentNet;
        this.parentEnv = nodeList.parentEnv;
        Util.log("NETICA: copy constructed a NodeList of length: " + this.size());
    }

    NodeList(long l, Net net) throws NeticaException {
        super(100);
        this.parentNet = net;
        this.parentEnv = net.parentEnv;
        int n = NETICA.LengthNodeList_bn(l);
        this.parentEnv.testForError();
        if (n < 0) {
            throw new NeticaException(6000, "Internal System Error; invalid native Netica nodelist");
        }
        for (int i = 0; i < n; ++i) {
            long l2 = NETICA.NthNode_bn(l, i);
            if (l2 == 0L) {
                this.add(null);
                continue;
            }
            Node node = Node.getNodeFromPtr(l2, net);
            this.add(node);
        }
        Util.log("NETICA: created NodeList of length: " + n);
    }

    public Net getNet() {
        return this.parentNet;
    }

    synchronized long getNodeListPtr() throws NeticaException {
        return this.getNodeListPtr(null);
    }

    synchronized long getNodeListPtr(Net net) throws NeticaException {
        long l = NETICA.NewNodeList_bn(0, this.parentEnv.envPtr);
        Net net2 = null;
        Enumeration enumeration = this.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            Node node = (Node)enumeration.nextElement();
            if (node == null) {
                NETICA.AddNodeToList_bn(0L, l, n++);
                continue;
            }
            if (net2 == null) {
                net2 = node.getNet();
                if (net != null && net2.netPtr != net.netPtr) {
                    throw new NeticaException("Nodelist has nodes from net " + net2.getName() + " when it should only have nodes from net " + net.getName());
                }
            } else if (node.getNet() != net2) {
                throw new NeticaException("Nodelist has nodes from different nets: " + net2.getName() + " and " + node.getNet().getName());
            }
            Util.log("nodelist[" + n + "]=" + node.getName());
            NETICA.AddNodeToList_bn(node.nodePtr, l, n++);
        }
        return l;
    }

    public Node getNode(int n) throws ArrayIndexOutOfBoundsException {
        return (Node)this.get(n);
    }

    public static int[] mapStateList(int[] nArray, NodeList nodeList, NodeList nodeList2) throws NeticaException {
        if (nArray.length != nodeList.size() || nArray.length != nodeList2.size()) {
            throw new NeticaException("srcStates.length, srcNodes.size(), and destNodes.size() must all be of equal length.");
        }
        nodeList.testIntegrity();
        nodeList2.testIntegrity();
        int[] nArray2 = new int[nArray.length];
        Object var4_4 = null;
        for (int i = 0; i < nodeList.size(); ++i) {
            Node node = (Node)nodeList.get(i);
            int n = nodeList2.indexOf(node);
            if (n < 0) {
                throw new NeticaException("The destination NodeList does not contain the same nodes as the source node. In particular, " + node + " is missing.");
            }
            nArray2[n] = nArray[i];
        }
        return nArray2;
    }

    void testIntegrity() throws NeticaException {
        Net net = null;
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Node node = (Node)enumeration.nextElement();
            if (node == null) continue;
            if (net == null) {
                net = node.getNet();
                continue;
            }
            if (node.getNet() == net) continue;
            throw new NeticaException("Nodelist has nodes from different nets: " + net.getName() + " and " + node.getNet().getName());
        }
    }

    void testfromNet(Net net) throws NeticaException {
        if (net == null) {
            return;
        }
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Node node = (Node)enumeration.nextElement();
            if (node.getNet() == net) continue;
            throw new NeticaException("Nodelist has nodes that are from : " + node.getNet().getName() + ", when they should all be from " + net.getName());
        }
    }
}

