/*
 * Decompiled with CFR 0.152.
 */
package norsys.netica;

import norsys.netica.Environ;
import norsys.netica.NETICA;
import norsys.netica.NeticaException;
import norsys.netica.Node;

public class Value {
    Node parent;
    Environ parentEnv;
    static final int FINDING_VALUE_TYPE = 1;
    static final int BELIEF_VALUE_TYPE = 2;
    static final int CALCULATED_VALUE_TYPE = 3;
    int valueType = 1;
    public static final int LIKELIHOOD_VALUE = -6;
    public static final int NO_VALUE = -3;
    public static final int REAL_VALUE = -25;
    public static final int STATE_VALUE = -20;
    public static final int STATE_NOT_VALUE = -7;

    Value(Node node, int n) {
        this.parent = node;
        this.parentEnv = node.parentEnv;
        switch (n) {
            case 1: {
                this.valueType = n;
                break;
            }
            default: {
                System.err.println(" No such Value.valueType: " + n);
                System.exit(-1);
            }
        }
    }

    public void clear() throws NeticaException {
        NETICA.RetractNodeFindings_bn(this.parent.nodePtr);
        this.parentEnv.testForError();
    }

    public void enterLikelihood(float[] fArray) throws NeticaException {
        this.assertFindingsOnly();
        NETICA.EnterNodeLikelihood_bn(this.parent.nodePtr, fArray);
        this.parentEnv.testForError();
    }

    public void enterReal(double d) throws NeticaException {
        this.assertFindingsOnly();
        NETICA.EnterNodeValue_bn(this.parent.nodePtr, d);
        this.parentEnv.testForError();
    }

    public void enterState(int n) throws NeticaException {
        this.assertFindingsOnly();
        NETICA.EnterFinding_bn(this.parent.nodePtr, n);
        this.parentEnv.testForError();
    }

    public void enterState(String string) throws NeticaException {
        this.assertFindingsOnly();
        int n = this.parent.state(string).getIndex();
        this.enterState(n);
    }

    public void enterStateNot(int n) throws NeticaException {
        this.assertFindingsOnly();
        NETICA.EnterFindingNot_bn(this.parent.nodePtr, n);
        this.parentEnv.testForError();
    }

    public int getKind() throws NeticaException {
        try {
            double d = this.getReal();
            return -25;
        }
        catch (Exception exception) {
            int n = this.getState();
            if (n == -7 || n == -6 || n == -3) {
                return n;
            }
            return -20;
        }
    }

    public float[] getLikelihood(float[] fArray) throws NeticaException {
        float[] fArray2 = NETICA.GetNodeLikelihood_bn(this.parent.nodePtr, fArray);
        this.parentEnv.testForError();
        return fArray2;
    }

    public Node getNode() {
        return this.parent;
    }

    public double getReal() throws NeticaException {
        double d = NETICA.GetNodeValueEntered_bn(this.parent.nodePtr);
        this.parentEnv.testForError();
        return d;
    }

    public int getState() throws NeticaException {
        int n = NETICA.GetNodeFinding_bn(this.parent.nodePtr);
        this.parentEnv.testForError();
        return n;
    }

    public void setReal(double d) throws NeticaException {
        int n = this.parent.getNet().getAutoUpdate();
        if (n != 0) {
            this.parent.getNet().setAutoUpdate(0);
        }
        this.clear();
        this.enterReal(d);
        if (n != 0) {
            this.parent.getNet().setAutoUpdate(n);
        }
    }

    public void setState(int n) throws NeticaException {
        int n2 = this.parent.getNet().getAutoUpdate();
        if (n2 != 0) {
            this.parent.getNet().setAutoUpdate(0);
        }
        this.clear();
        this.enterState(n);
        if (n2 != 0) {
            this.parent.getNet().setAutoUpdate(n2);
        }
    }

    public void setState(String string) throws NeticaException {
        int n = this.parent.getNet().getAutoUpdate();
        if (n != 0) {
            this.parent.getNet().setAutoUpdate(0);
        }
        this.clear();
        this.enterState(string);
        if (n != 0) {
            this.parent.getNet().setAutoUpdate(n);
        }
    }

    private void assertFindingsOnly() throws NeticaException {
        if (this.valueType != 1) {
            throw new NeticaException("You may only call this method on Value objects of type Value.FINDING_VALUE_TYPE");
        }
    }
}

