/*
 * Decompiled with CFR 0.152.
 */
package norsys.netica.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.text.NumberFormat;
import java.util.EventListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import norsys.netica.NeticaException;
import norsys.netica.Node;
import norsys.netica.VisualNode;
import norsys.netica.gui.DataDisplayer;
import norsys.netica.gui.NodePanel_BeliefBars;
import norsys.netica.gui.NodePanel_Circle;
import norsys.netica.gui.NodePanel_LabeledBox;
import norsys.netica.gui.NodePanel_Text;
import norsys.netica.gui.RecursingEventListener;

public abstract class NodePanel
extends JPanel
implements RecursingEventListener,
DataDisplayer {
    static String NETICA_APPL_STYLE_BELIEF_BARS = "belief_bars";
    static String NETICA_APPL_STYLE_LABELED_BOX = "labeled_box";
    static String NETICA_APPL_STYLE_SMALL_SHAPE = "small_shape";
    static String NETICA_APPL_STYLE_METER = "meter";
    public static final int NODE_STYLE_AUTO_SELECT = 0;
    public static final int NODE_STYLE_LABELED_BOX = 1;
    public static final int NODE_STYLE_CIRCLE = 2;
    public static final int NODE_STYLE_ABSENT = 3;
    public static final int NODE_STYLE_BELIEF_BARS = 4;
    public static final int NODE_STYLE_TEXT = 5;
    public static final int DISPLAY_MODE_GRAYED = 0;
    public static final int DISPLAY_MODE_NORMAL = 1;
    public static final int DISPLAY_MODE_HILITED = 2;
    public static final int PROBABILITY_FORMAT_1 = 1;
    public static final int PROBABILITY_FORMAT_2 = 2;
    public static final int PROBABILITY_FORMAT_3 = 3;
    public static final int PROBABILITY_FORMAT_4 = 4;
    public static Color defaultBackgroundColor_NatureNode = new Color(255, 250, 220);
    public static Color defaultBackgroundColor_UtilityNode = new Color(192, 220, 192);
    public static Color defaultBackgroundColor_DecisionNode = new Color(0, 255, 255);
    public static Color defaultBackgroundColor_ConstantNode = null;
    public static Color defaultBorderColor = Color.black;
    public static Color grayedModeBGColor = Color.gray;
    public static Color hilitedModeBGColor = Color.red;
    public static Color defaultForegroundColor = Color.black;
    public static Font defaultTitleFont = new Font("SansSerif", 1, 14);
    public static Border defaultTitleBorder = BorderFactory.createEmptyBorder(2, 8, 2, 8);
    public static int probabilitiesFormat = 2;
    public JLabel nodeTitleJLabel;
    Node parentNode;
    VisualNode parentVisualNode;
    int style = 0;
    Color normalModeBGColor;
    int displayMode = 1;
    int nodeKind;
    int xPos;
    int yPos;
    static NumberFormat numFormat1 = NumberFormat.getPercentInstance();

    NodePanel(Node node) throws Exception {
        this.parentNode = node;
        this.parentVisualNode = node.visual();
        this.nodeKind = node.getKind();
    }

    public static NodePanel createNodePanel(Node node, int n) throws NeticaException {
        NodePanel nodePanel = null;
        if (node.getKind() == 205 && n != 3) {
            n = 3;
        }
        try {
            switch (n) {
                case 0: {
                    String string = node.getName();
                    if (node.visual().getStyle() != null) {
                        String string2 = node.visual().getStyle();
                        if (string2.startsWith(NETICA_APPL_STYLE_LABELED_BOX)) {
                            nodePanel = NodePanel.createNodePanel(node, 1);
                            break;
                        }
                        if (string2.startsWith(NETICA_APPL_STYLE_SMALL_SHAPE)) {
                            nodePanel = NodePanel.createNodePanel(node, 2);
                            break;
                        }
                        if (string2.startsWith(NETICA_APPL_STYLE_BELIEF_BARS)) {
                            nodePanel = NodePanel.createNodePanel(node, 4);
                            break;
                        }
                        nodePanel = NodePanel.createNodePanel(node, 4);
                        break;
                    }
                    if (node.getKind() == 202 && string.startsWith("TITLE") && string.length() > 5 && "0123456789".indexOf(string.charAt(5)) >= 0 || string.startsWith("NOTE") && string.length() > 4 && "0123456789".indexOf(string.charAt(4)) >= 0) {
                        nodePanel = NodePanel.createNodePanel(node, 5);
                        break;
                    }
                    nodePanel = NodePanel.createNodePanel(node, 4);
                    break;
                }
                case 2: {
                    nodePanel = new NodePanel_Circle(node);
                    break;
                }
                case 1: {
                    nodePanel = new NodePanel_LabeledBox(node);
                    break;
                }
                case 3: {
                    nodePanel = new NodePanel_Circle(node);
                    nodePanel.style = 3;
                    Point point = nodePanel.getCenter();
                    nodePanel.setBounds(point.x - 5, point.y - 5, 10, 10);
                    break;
                }
                case 4: {
                    if (node.getKind() == 201 || node.getKind() == 203) {
                        nodePanel = new NodePanel_BeliefBars(node);
                        break;
                    }
                    nodePanel = new NodePanel_LabeledBox(node);
                    break;
                }
                case 5: {
                    nodePanel = new NodePanel_Text(node);
                    break;
                }
                default: {
                    throw new NeticaException("Invalid VisualNode style");
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new NeticaException("Internal NeticaJ error creating a NodePanel for node: " + node.getName());
        }
        if (nodePanel == null) {
            throw new NeticaException("null panel for node=" + node.getName());
        }
        return nodePanel;
    }

    public void addListenerToAllComponents(EventListener eventListener) {
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (eventListener instanceof MouseMotionListener) {
                componentArray[i].addMouseMotionListener((MouseMotionListener)eventListener);
            }
            if (eventListener instanceof MouseListener) {
                componentArray[i].addMouseListener((MouseListener)eventListener);
            }
            if (!(componentArray[i] instanceof RecursingEventListener)) continue;
            ((RecursingEventListener)((Object)componentArray[i])).addListenerToAllComponents(eventListener);
        }
    }

    public int getDisplayMode() {
        return this.displayMode;
    }

    public Node getNode() throws NeticaException {
        return this.parentNode;
    }

    public int getStyle() {
        return this.style;
    }

    public void moveBy(int n, int n2) throws NeticaException {
        Point point = this.getLocation();
        this.setLocation(point.x + n, point.y + n2);
        double[] dArray = this.parentVisualNode.getPosition();
        this.parentVisualNode.setPosition(dArray[0] + (double)n, dArray[1] + (double)n2);
    }

    public void refreshDataDisplayed() throws NeticaException {
        if (this.nodeTitleJLabel != null) {
            String string = this.parentNode.getTitle();
            if (string.equals("")) {
                string = this.parentNode.getName();
            }
            this.nodeTitleJLabel.setText(string);
            Component[] componentArray = this.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                if (!(componentArray[i] instanceof DataDisplayer)) continue;
                DataDisplayer dataDisplayer = (DataDisplayer)((Object)componentArray[i]);
                dataDisplayer.refreshDataDisplayed();
            }
        }
        this.repaint();
    }

    public void removeListenerFromAllComponents(EventListener eventListener) {
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (eventListener instanceof MouseMotionListener) {
                componentArray[i].removeMouseMotionListener((MouseMotionListener)eventListener);
            }
            if (eventListener instanceof MouseListener) {
                componentArray[i].removeMouseListener((MouseListener)eventListener);
            }
            if (!(componentArray[i] instanceof RecursingEventListener)) continue;
            ((RecursingEventListener)((Object)componentArray[i])).removeListenerFromAllComponents(eventListener);
        }
    }

    public void setDisplayMode(int n) {
        if (n != this.displayMode) {
            this.displayMode = n;
            if (this.isVisible()) {
                this.repaint();
            }
        }
    }

    protected void setupPanel() throws Exception {
        if (this.style == 5) {
            this.setBackground(null);
        } else {
            this.setBorder(BorderFactory.createLineBorder(defaultBorderColor));
            switch (this.nodeKind) {
                case 203: {
                    this.setBackground(defaultBackgroundColor_DecisionNode);
                    break;
                }
                case 204: {
                    this.setBackground(defaultBackgroundColor_UtilityNode);
                    break;
                }
                case 202: {
                    this.setBackground(defaultBackgroundColor_ConstantNode);
                    break;
                }
                case 205: {
                    this.setBackground(null);
                    break;
                }
                default: {
                    this.setBackground(defaultBackgroundColor_NatureNode);
                }
            }
        }
        this.normalModeBGColor = this.getBackground();
    }

    public void paintComponent(Graphics graphics) {
        this.manageDisplayMode();
        super.paintComponent(graphics);
    }

    void manageDisplayMode() {
        Color color = null;
        Color color2 = this.getBackground();
        switch (this.displayMode) {
            case 0: {
                color = grayedModeBGColor;
                break;
            }
            case 2: {
                color = hilitedModeBGColor;
                break;
            }
            default: {
                color = this.normalModeBGColor;
            }
        }
        if (color == null) {
            if (color2 != null && (this.getParent() == null || color2 != this.getParent().getBackground())) {
                this.setBackground(null);
            }
        } else if (!color.equals(color2)) {
            this.setBackground(color);
        }
    }

    Point getVisualNodeCenter() throws NeticaException {
        double[] dArray = this.parentVisualNode.getPosition();
        return new Point((int)dArray[0], (int)dArray[1]);
    }

    Point getCenter() {
        Rectangle rectangle = this.getBounds();
        return new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
    }

    static String sigDigits(double d, int n, boolean bl) {
        int n2;
        int n3;
        if (n < 0) {
            return "" + d;
        }
        double d2 = Math.round(Math.pow(10.0, n));
        d = (double)Math.round(d * d2) / d2;
        String string = "" + d;
        if (bl && (n3 = string.indexOf(46)) >= 0 && (n2 = string.length() - n3 - 1) < n) {
            string = string + "000000000000000000".substring(0, n - n2);
        }
        if (d > 0.0 && "0.00000000000000".indexOf(string) >= 0) {
            string = string.substring(0, string.length() - 1) + "+";
        }
        return string;
    }

    static String prob2String(double d, int n) {
        switch (n) {
            case 1: {
                return numFormat1.format(d);
            }
            case 2: {
                return NodePanel.sigDigits(d * 100.0, 1, true);
            }
            case 3: {
                return NodePanel.sigDigits(d, 2, true);
            }
            case 4: {
                return NodePanel.sigDigits(d, 3, true);
            }
        }
        System.err.println("Invalid probability format: " + n);
        return "" + d;
    }

    static void drawDashedLine(Graphics graphics, int n, int n2, int n3, int n4, double d, double d2) {
        double d3 = Math.sqrt((n3 - n) * (n3 - n) + (n4 - n2) * (n4 - n2));
        double d4 = (double)(n4 - n2) / (d3 / (d + d2));
        double d5 = (double)(n3 - n) / (d3 / (d + d2));
        double d6 = (double)(n4 - n2) / (d3 / (d + d2));
        double d7 = (double)(n3 - n) / (d3 / d);
        double d8 = (double)(n4 - n2) / (d3 / d);
        int n5 = 0;
        for (double d9 = 0.0; d9 < d3 - d; d9 += d + d2) {
            graphics.drawLine((int)((double)n + d5 * (double)n5), (int)((double)n2 + d6 * (double)n5), (int)((double)n + d5 * (double)n5 + d7), (int)((double)n2 + d6 * (double)n5 + d8));
            ++n5;
        }
        if ((d + d2) * (double)n5 <= d3) {
            graphics.drawLine((int)((double)n + d5 * (double)n5), (int)((double)n2 + d6 * (double)n5), n3, n4);
        }
    }

    static void drawFilledHexagon(Graphics graphics, int n, int n2, Color color, Color color2) {
        int n3 = n / 2;
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        nArray[0] = 0;
        nArray2[0] = n3;
        nArray[1] = n3;
        nArray2[1] = 0;
        nArray[2] = 0;
        nArray2[2] = 0;
        graphics.fillPolygon(nArray, nArray2, 3);
        nArray2[1] = nArray2[2] = n;
        graphics.fillPolygon(nArray, nArray2, 3);
        nArray[0] = nArray[2] = n2;
        nArray[1] = n2 - n3 - 1;
        graphics.fillPolygon(nArray, nArray2, 3);
        nArray2[2] = 0;
        nArray2[1] = 0;
        graphics.fillPolygon(nArray, nArray2, 3);
        int[] nArray3 = new int[6];
        int[] nArray4 = new int[6];
        nArray3[0] = 0;
        nArray4[0] = n3;
        nArray3[1] = n3;
        nArray4[1] = 0;
        nArray3[2] = n2 - n3 - 1;
        nArray4[2] = 0;
        nArray3[3] = n2 - 1;
        nArray4[3] = n3;
        nArray3[4] = n2 - n3 - 1;
        nArray4[4] = n - 1;
        nArray3[5] = n3;
        nArray4[5] = n - 1;
        if (color2 != null) {
            graphics.setColor(color2);
            graphics.fillPolygon(nArray3, nArray4, 6);
        }
        graphics.setColor(color);
        graphics.drawPolygon(nArray3, nArray4, 6);
    }
}

