/* 
 *  BuildNet.java
 *
 *  Example use of Netica-J to construct a Bayes net and save it to file.
 */
import norsys.netica.*;
import norsys.neticaEx.aliases.Node;
     
public class BuildNet {

  public static void main (String[] args){
    try {
	Node.setConstructorClass ("norsys.neticaEx.aliases.Node");
	Environ env = new Environ (null);

	Net net = new Net();
	net.setName("ChestClinic");

	Node tuberculosis = new Node ("Tuberculosis","present,absent",  net);
	Node smoking      = new Node ("Smoking",     "smoker,nonsmoker",net);
	Node cancer       = new Node ("Cancer",      "present,absent",  net);
	Node tbOrCa       = new Node ("TbOrCa",      "true,false",      net);
	Node xRay         = new Node ("XRay",        "abnormal,normal", net);
	Node visitAsia    = new Node ("VisitAsia",   "visit,no_visit",  net);

	visitAsia.setTitle ("Visit to Asia");
	cancer.setTitle ("Lung Cancer");
	tbOrCa.setTitle ("Tuberculosis or Cancer");

	visitAsia.state("visit").setTitle ("Visited Asia within the last 3 years");
	
	tuberculosis.addLink (visitAsia); // link from visitAsia to tuberculosis
	cancer.addLink (smoking);
	tbOrCa.addLink (tuberculosis);
	tbOrCa.addLink (cancer);
	xRay.addLink (tbOrCa);

	visitAsia.setCPTable (0.01, 0.99);
	smoking.setCPTable (0.5, 0.5);

	                       // VisitAsia   present  absent
	tuberculosis.setCPTable ("visit",     0.05,    0.95);
	tuberculosis.setCPTable ("no_visit",  0.01,    0.99);

	                 // Smoking      present  absent
	cancer.setCPTable ("smoker",     0.1,     0.9);
	cancer.setCPTable ("nonsmoker",  0.01,    0.99);
	
	               // TbOrCa    abnormal normal
	xRay.setCPTable ("true",    0.98,    0.02);
	xRay.setCPTable ("false",   0.05,    0.95);

	tbOrCa.setEquation ("TbOrCa (Tuberculosis, Cancer) = Tuberculosis || Cancer");
	tbOrCa.equationToTable (1, false, false);

	Streamer stream = new Streamer ("ChestClinicBuilt.dne");
	net.write (stream);

	net.finalize();  // free resources immediately and safely; not strictly necessary, but a good habit
    }
    catch (Exception e) {
	e.printStackTrace();
    }
  }
}
