/* 
 *  LearnCPTs.java
 *
 *  Example use of Netica-J for learning the CPTs of a Bayes net
 *  from a file of cases.
 */

import java.io.File;
import norsys.netica.*;

public class LearnCPTs {

  public static void main(String[] args) {
    System.out.println( "Running Netica-J LearnCPTs example..." );

    try {
	Environ env = new Environ (null);

	// Read in the net created by the BuildNet.java example program
	Net      net      = new Net (new Streamer ("ChestClinicBuilt.dne"));
	NodeList nodes    = net.getNodes();
	int      numNodes = nodes.size();
	
	// Remove CPTables of nodes in net, so new ones can be learned.
	for (int n = 0;  n < numNodes;  n++) {
	    Node node = (Node) nodes.get (n);
	    node.deleteTables();
	}
	

	// Read in the case file created by the the SimulateCases.java
	// example program, and learn new CPTables.
	Streamer caseFile = new Streamer ("ChestClinic.cas");
	net.reviseCPTsByCaseFile (caseFile, nodes, 1.0);

	net.write (new Streamer ("Learned_ChestClinic.dne"));
	
	net.finalize();   // not strictly necessary, but a good habit
    }
    catch (Exception e) {
	e.printStackTrace();
    }
  }
}

	/* ==============================================================
	 * This alternate way can replace the net.reviseCPTsByCaseFile
	 * line above, if you need to filter or adjust individual cases.
	 
	long[] casePosn = new long[1];
	casePosn[0] = Net.FIRST_CASE;
	while (true) {
	    net.retractFindings();
	    net.readCase (casePosn, caseFile, nodes, null, null);
	    if (casePosn[0] == Net.NO_MORE_CASES) break;
	    
	    net.reviseCPTsByFindings (nodes, 1.0);
	    casePosn[0] = Net.NEXT_CASE;
	}
	  ============================================================== */
	
