/* 
 *  LearnLatent.java
 *
 *  Example use of Netica-J for learning a latent (hidden) variable
 *  using the EM Learning technique.
 */

import java.io.File;
import norsys.netica.*;

public class LearnLatent {

  public static void main(String[] args) {
    System.out.println( "Running Netica-J LearnLatent example..." );

    try {
	Environ env = new Environ (null);

	/* Build the net */
	Net      net      = new Net (env);
	net.setName ("Learned_Latent");

	Node     r        = new Node ("R", 2, net);
	Node     s        = new Node ("S", 2, net);
	Node     t        = new Node ("T", 2, net);
	r.state(0).setName ("false");
	r.state(1).setName ("true");
	s.state(0).setName ("false");
	s.state(1).setName ("true");
	t.state(0).setName ("false");
	t.state(1).setName ("true");

	Node     a        = new Node ("A", 2, net); // the latent node; trying 2 states
	//Node   a        = new Node ("A", 3, net); // the latent node; trying 3 states

	r.addLink (a);
	s.addLink (a);
	t.addLink (a);

	NodeList nodes    = net.getNodes();
	int      numNodes = nodes.size();

	// Read in the case file into a caseset

	Caseset cases = new Caseset (env);
	Streamer caseFile = new Streamer ("LearnLatent.cas", env);
	cases.addCases ( caseFile, 1.0);
	Learner learner = new Learner (Learner.EM_LEARNING, env);
	learner.setMaxIterations (100);
	
	learner.learnCPTs ( nodes, cases, 1.0);

	net.write (new Streamer ("Learned_Latent.dne"));
	
	net.finalize();   // not strictly necessary, but a good habit
    }
    catch (Exception e) {
	e.printStackTrace();
    }
  }
}

	/* ==============================================================
	 * This alternate way can replace the net.reviseCPTsByCaseFile
	 * line above, if you need to filter or adjust individual cases.
	 
	long[] casePosn = new long[1];
	casePosn[0] = Net.FIRST_CASE;
	while (true) {
	    net.retractFindings();
	    net.readCase (casePosn, caseFile, nodes, null, null);
	    if (casePosn[0] == Net.NO_MORE_CASES) break;
	    
	    net.reviseCPTsByFindings (nodes, 1.0);
	    casePosn[0] = Net.NEXT_CASE;
	}
	  ============================================================== */
	
